<?php
session_start();
if (isset($_SESSION['_session']['user']) &&  (time() - $_SESSION['_session']['LAST_ACTIVITY']  < $_SESSION['_session']['koha'])) {

    $_SESSION['_session']['LAST_ACTIVITY']  = time();

    require('fpdf.php');
    $url = "htts://atommed.net/service1/api";
    $vid = $_GET['vid'];

    $opts = [
        "http" => [
            "method" => "GET",
            "header" => "api_token:" . $_SESSION['_session']['token'],

        ]

    ];
    $context = stream_context_create($opts);
    if (!function_exists('str_contains')) {
        function str_contains(string $haystack, string $needle): bool
        {
            return '' === $needle || false !== strpos($haystack, $needle);
        }
    }

    $str_data = file_get_contents($url . "/getbyvisit/" . $vid, false, $context);

    $config = file_get_contents($url . "/getservicepdf", false, $context);
    $configd = json_decode($config, true);

    $paisja_data = file_get_contents($url . "/getpaisjevisit/" . $vid, false, $context);

    $data = json_decode($str_data, true);
    $length = count($data);

    $datapaisje = json_decode($paisja_data, true);
    $lengthpaisje = count($datapaisje);
    $vulat = "../assets/img/vulafake.png";
    $image1 = "../../../images/Atommed.png";
    $checkedimg = "../assets/img/checked.jpg";
    $uncheckedimg = "../assets/img/unchecked.png";
    function getImage($dataURI){
        $img = explode(',',$dataURI,2);
        $pic = 'data://text/plain;base64,'.$img[1];
        $type = explode("/", explode(':', substr($dataURI, 0, strpos($dataURI, ';')))[1])[1]; // get the image type
        if ($type=="png"||$type=="jpeg"||$type=="gif") return array($pic, $type);
        return false;
      }
    class PDF extends FPDF
    {
        // Page header
        function Header()
        {
            global  $configd;

            $this->SetFont('Times', '', 10);
            $this->SetDrawColor(211, 211, 211);
            if ($configd['code'] == 200) {
                $el = $configd['data'][0];
                if ($el['foto'] != '') {
                    $pic = getImage($el['foto']);
                    $this->Cell(65, 20, $this->Image($pic[0], $this->GetX()+1, $this->GetY()+1, 63,17,$pic[1]), 1);
                } else {
                    $this->Cell(65, 20, $this->Image("../../../images/Atommed.png", $this->GetX(), $this->GetY(), 65), 1);
                }
                $this->SetXY($this->GetX(), $this->GetY());
                $this->Cell(80, 10, $el['Titulli'], 1, 0,'C');
                if ($el['NrFaqev'] == 1) {
                    $this->Cell(45, 10, $el['Kodi'], 1, 0,'C');
                }else{
                    $this->Cell(45, 20, $el['Kodi'], 1, 0,'C');
                }
             
                $this->SetXY(75, $this->GetY() + 10);
                $this->Cell(80, 10, $el['Versioni'], 1, 0,'C');

                if ($el['NrFaqev'] == 1) {
                    $this->Cell(45, 10, 'Faqja ' . $this->PageNo() . ' nga {t}', 1, 0, 'C');
                }else{
                    
                }
                $this->SetLineWidth(0.5);
                $this->SetDrawColor(0, 0, 0);
                $this->SetFont('Times', '', 14);
                $this->Line(220, $this->GetY() + 15, 0, $this->GetY() + 15);
                $this->SetXY(0, 34);
                $this->Ln(8);
            } else {
                $this->Cell(65, 20, $this->Image("../../../images/Atommed.png", $this->GetX(), $this->GetY(), 60), 1);
                $this->SetXY($this->GetX(), $this->GetY());
                $this->Cell(80, 10, 'Raport Servisimi ', 1, 0, 'C');
                $this->Cell(45, 10, 'FO-810-2', 1, 0, 'C');
                $this->SetXY(75, $this->GetY() + 10);
                $this->Cell(80, 10, 'ver. 1.0', 1, 0, 'C');
                $this->Cell(45, 10, 'Faqja ' . $this->PageNo() . ' nga {t}', 1, 0, 'C');

                $this->SetLineWidth(0.5);
                $this->SetDrawColor(0, 0, 0);
                $this->SetFont('Times', '', 14);
                $this->Line(220, $this->GetY() + 15, 0, $this->GetY() + 15);
                $this->SetXY(0, 34);
                $this->Ln(8);
            }
        }
        function newp()
        {
            global  $pershkrimipunes;
            global $Testetekryera;
            global $kohapershkrim;
            global $Aparaticheck;
            global $Shenimevizit;
            global $materialekonsumi;
            $this->MultiCell(210, 6, "\r\n \r\n \r\n \r\n \r\n \r\n ", 'B',  'L', false);
            $this->SetFont('Times', '', 12);
            $this->SetXY(10, $this->GetY());
            $this->Cell(0, 20, utf8_decode('PËRSHKRIMI I PUNIMEVE'), 0, 0, 'L');
            $this->Ln();
            $this->SetFont('Times', 'B', 10);
            $this->SetLineWidth(0.4);
            $this->SetDrawColor(211, 211, 211);
            $this->Line(204, $this->GetY() - 7, 6, $this->GetY() - 7);
            $this->SetXY(10, $this->GetY());
            $this->Cell(25, 4, utf8_decode('Përshkrimi i punimeve'), 0, 0, 'L');
            $this->SetXY(10, $this->GetY() + 8);
            $this->SetFont('Times', '', 10);
            $this->MultiCell(95, 6, utf8_decode($pershkrimipunes), 'B',  'L', false);
            $this->SetFont('Times', 'B', 10);
            $this->SetXY(110, $this->GetY() - 14);
            $this->Cell(25, 4, utf8_decode('Teste të kryera:'), 0, 0, 'L');
            $this->SetXY(110, $this->GetY() + 8);
            $this->SetFont('Times', '', 10);
            $this->MultiCell(40, 6, utf8_decode($Testetekryera), 'B',  'L', false);
            $this->SetFont('Times', 'B', 10);
            $this->SetXY(160, $this->GetY() - 14);
            $this->Cell(25, 4, utf8_decode('Koha:'), 0, 0, 'L');
            $this->SetXY(160, $this->GetY() + 8);
            $this->SetFont('Times', '', 10);
            $this->MultiCell(44, 6, utf8_decode($kohapershkrim), 'B',  'L', false);
            if ($Aparaticheck == 1) {
                $this->Cell(40, 5, $this->Image("../assets/img/checked.jpg", $this->GetX(), $this->GetY() + 2, 4));
            } else {
                $this->Cell(40, 5, $this->Image("../assets/img/unchecked.png", $this->GetX(), $this->GetY() + 2, 4));
            }
            $this->SetXY(15, $this->GetY() + 2);
            $this->Cell(0, 4, utf8_decode('Aparati u dorëzua në gjendje të mirë pune'), 0, 0, 'L');
            $this->SetXY(10, $this->GetY() + 8);
            $this->SetFont('Times', 'B', 10);
            $this->Cell(25, 4, utf8_decode('Shënime për vizitën tjetër '), 0, 0, 'L');
            $this->SetXY(10, $this->GetY() + 10);
            $this->SetFont('Times', '', 10);
            $this->MultiCell(95, 4, utf8_decode($Shenimevizit), 'B',  'L', false);
            $this->SetXY(110, $this->GetY() - 14);
            $this->SetFont('Times', 'B', 10);
            $this->Cell(25, 4, utf8_decode('Pjesë/materiale konsumi...'), 0, 0, 'L');
            $this->SetXY(110, $this->GetY() + 10);
            $this->SetFont('Times', '', 10);
            $this->MultiCell(95, 4, utf8_decode($materialekonsumi), 'B',  'L', false);
        }

        // Page footer
        function Footer()
        {
            global $emri;
            global $mbiemri;
            global $emripr;
            global $mbiemripr;


            $this->Line(210, 263, 0, 263);
            $this->SetXY(10, -29);

            $this->Cell(60, 10, "Klienti:", 0, 0, 'L');
            $this->SetXY(10, -23);

            $this->Cell(30, 10, utf8_decode($emripr . ' ' . $mbiemripr), 'B', 0, 'L');
            $this->SetXY(90, -34);

            $this->Cell(60, 21, $this->Image('../assets/img/vulafake.png', $this->GetX(), $this->GetY(), 30), 0, 0, 'L');
            $this->SetXY(160, -29);
            $this->Cell(60, 10, "Serviseri:", 0, 0, 'L');
            $this->SetXY(160, -23);
            $this->Cell(30, 10, utf8_decode($emri . ' ' . $mbiemri), 'B', 0, 'L');
            //    $this->SetXY(87, -15);
            // $this->Cell(0, 5, 'RAPORT SERVISI', 0, 0, 'C');

            $this->SetXY(26, -10);

            //    $this->Cell(0,5,'Faqja '.$this->PageNo().' nga {t}',0,0 ,'C');
        }
    }

    $pdf = new PDF('P', 'mm', 'A4');
    $pdf->AliasNbPages('{t}');
    for ($i = 0; $i < $lengthpaisje; $i++) {
        $servis_data = file_get_contents($url . "/getservisit/" . $vid . "/" . $datapaisje[$i]["paisjaid"], false, $context);

        $dataser = json_decode($servis_data, true);
        $lengthser = count($dataser);
        $sername = '';
        for ($j = 0; $j < $lengthser; $j++) {
            $sername .= $dataser[$j]["service_name"] . ',';
        }
        $sername = substr($sername, 0, -1);
        $pdf->AddPage();

        $pdf->SetFont('Times', '', 12);
        $pdf->SetXY(5, 26);
        $pdf->Cell(0, 40, utf8_decode('TË DHËNAT E KLIENTIT'), 0, 0, 'L');

        $pdf->SetLineWidth(0.4);
        $pdf->SetDrawColor(211, 211, 211);
        $pdf->Line(204, 48, 6, 48);
        $pdf->SetFont('Times', '', 12);
        $pdf->SetXY(5, 50);

        $pdf->Cell(12, 4, utf8_decode('Laboratori:'), 0, 0, 'L');
        $pdf->Cell(0, 4, utf8_decode('Personi Përgjegjës:'), 0, 0, 'C');
        $pdf->SetXY(186, 50);
        $pdf->Cell(12, 4, utf8_decode('Departamenti:'), 0, 0, 'C');
        $pdf->Ln();
        $pdf->SetFont('Times', 'B', 12);
        $pdf->SetXY(5, 37);
        $emri = $data[0]["emri"];
        $mbiemri = $data[0]["mbiemri"];
        $emripr = $data[0]["pranemri"];
        $mbiemripr = $data[0]["pranmbiemri"];
        $pershkrimipunes = $dataser[0]["pershkrimipunes"];
        $Testetekryera = $dataser[0]["Testetekryera"];
        $kohapershkrim = $dataser[0]["kohapershkrim"];
        $Aparaticheck = $dataser[0]["Aparaticheck"];
        $Shenimevizit = $dataser[0]["Shenimevizit"];
        $materialekonsumi =  $dataser[0]["materialekonsumi"];
        $pdf->Cell(12, 40, utf8_decode($data[0]["emri_institutit"]), 0, 0, 'L');
        $pdf->Cell(0, 40, utf8_decode($data[0]["pranemri"] . ' ' . $data[0]["pranmbiemri"]), 0, 0, 'C');
        $pdf->Cell(-14, 40, utf8_decode('dep'), 0, 0, 'C');
        $pdf->Ln();
        $pdf->SetFont('Times', '', 12);
        $pdf->SetXY(5, 76);
        $pdf->Cell(0, -20, utf8_decode('TË DHËNAT E KËRKESËS'), 0, 0, 'L');
        $pdf->Line(204, 68, 6, 68);
        $pdf->Ln();

        $pdf->Cell(12, 35, utf8_decode('Aparati:'), 0, 0, 'L');
        $pdf->Cell(125, 35, utf8_decode('Serviset:'), 0, 0, 'C');
        $pdf->Cell(18, 35, utf8_decode('Versioni i programit:'), 0, 0, 'C');
        $pdf->Cell(50, 35, utf8_decode('Numri Serik:'), 0, 0, 'C');
        $pdf->Ln();
        $pdf->SetFont('Times', 'B', 10);

        $pdf->SetY(77);
        $pdf->MultiCell(60, 5, utf8_decode($datapaisje[$i]["emri_pajisjes"]), 0, 'L', false);

        $pdf->SetXY(77, 77);
        $pdf->SetFont('Times', 'B', 9);
        $pdf->MultiCell(60, 3.3, utf8_decode($sername), 0, 'L', false);
        $pdf->SetXY(138, 77);
        $pdf->SetFont('Times', 'B', 10);
        $pdf->MultiCell(35, 5, utf8_decode($datapaisje[$i]["versioni_programit"]), 0, 'L', false);
        $pdf->SetXY(179, 77);

        $pdf->MultiCell(30, 5, utf8_decode($datapaisje[$i]["numri_serik"]), 0, 'L', false);
        $pdf->Ln();
        $pdf->SetLineWidth(0.8);
        if (strlen($data[0]["pershkrimi"]) > 131) {
            $pershkrlength = strlen($data[0]["pershkrimi"]) / 18;
        } else {
            $pershkrlength = 6;
        }
        $pdf->RoundedRect(0.2, 100, 209.5, $pershkrlength, 3.5);
        $pdf->Cell(50, 21, utf8_decode('Përshkrimi i problemit në kërkesë - Komenti:'), 0, 0, 'C');
        $pdf->SetFont('Times', '', 10);
        $pdf->SetXY(0.2, 100);
        $pdf->MultiCell(209.5, 5, utf8_decode($data[0]["pershkrimi"]), 0, 'L', false);
        $pdf->Ln();
        $pdf->SetFont('Times', 'B', 10);
        if ($dataser[0]["Kontrat"] == 1) {
            $pdf->Cell(40, 5, $pdf->Image($checkedimg, $pdf->GetX() - 4, $pdf->GetY(), 4));
        } else {
            $pdf->Cell(40, 5, $pdf->Image($uncheckedimg, $pdf->GetX() - 4, $pdf->GetY(), 4));
        }
        $pdf->SetX(10);
        $pdf->Cell(0, 4, utf8_decode('Kontratë'), 0, 0, 'L');
        if ($dataser[0]["Falas"] == 1) {
            $pdf->Cell(60, 5, $pdf->Image($checkedimg, $pdf->GetX() - 157, $pdf->GetY(), 4));
        } else {
            $pdf->Cell(60, 5, $pdf->Image($uncheckedimg, $pdf->GetX() - 157, $pdf->GetY(), 4));
        }
        $pdf->SetX(47);
        $pdf->Cell(0, 4, utf8_decode('Falas'), 0, 0, 'L');
        if ($dataser[0]["Garancion"] == 1) {
            $pdf->Cell(60, 5, $pdf->Image($checkedimg, $pdf->GetX() - 125, $pdf->GetY(), 4));
        } else {
            $pdf->Cell(60, 5, $pdf->Image($uncheckedimg, $pdf->GetX() - 125, $pdf->GetY(), 4));
        }
        $pdf->SetX(79);
        $pdf->Cell(0, 4, utf8_decode('Garancion'), 0, 0, 'L');
        if ($dataser[0]["Reagjentesh"] == 1) {
            $pdf->Cell(60, 5, $pdf->Image($checkedimg, $pdf->GetX() - 84, $pdf->GetY(), 4));
        } else {
            $pdf->Cell(60, 5, $pdf->Image($uncheckedimg, $pdf->GetX() - 84, $pdf->GetY(), 4));
        }
        $pdf->SetX(120);
        $pdf->Cell(0, 4, utf8_decode('Përdorim Reagjentësh'), 0, 0, 'L');
        if ($dataser[0]["Qera"] == 1) {
            $pdf->Cell(60, 5, $pdf->Image($checkedimg, $pdf->GetX() - 26, $pdf->GetY(), 4));
        } else {
            $pdf->Cell(60, 5, $pdf->Image($uncheckedimg, $pdf->GetX() - 26, $pdf->GetY(), 4));
        }
        $pdf->SetX(178);
        $pdf->Cell(0, 4, utf8_decode('Qera'), 0, 0, 'L');

        $pdf->Ln();
        $pdf->SetFont('Times', '', 12);
        $pdf->Cell(0, 20, utf8_decode('PËRSHKRIMI I PROBLEMIT'), 0, 0, 'L');
        $pdf->Ln();
        $pdf->SetFont('Times', 'B', 10);
        $pdf->SetLineWidth(0.4);
        $pdf->SetDrawColor(211, 211, 211);
        $pdf->Line(204, 130, 6, 130);
        if ($dataser[0]["pershkrimiproblemit"] != null) {
            if (str_contains($dataser[0]["pershkrimiproblemit"], 'Teknik')) {
                $pdf->Cell(40, 5, $pdf->Image($checkedimg, $pdf->GetX() - 4, $pdf->GetY(), 4));
            } else {
                $pdf->Cell(40, 5, $pdf->Image($uncheckedimg, $pdf->GetX() - 4, $pdf->GetY(), 4));
            }
        } else {
            $pdf->Cell(40, 5, $pdf->Image($uncheckedimg, $pdf->GetX() - 4, $pdf->GetY(), 4));
        }
        $pdf->SetX(10);
        $pdf->Cell(0, 4, utf8_decode('Teknik'), 0, 0, 'L');
        if ($dataser[0]["pershkrimiproblemit"] != null) {
            if (str_contains($dataser[0]["pershkrimiproblemit"], 'Kimik')) {
                $pdf->Cell(60, 5, $pdf->Image($checkedimg, $pdf->GetX() - 157, $pdf->GetY(), 4));
            } else {
                $pdf->Cell(60, 5, $pdf->Image($uncheckedimg, $pdf->GetX() - 157, $pdf->GetY(), 4));
            }
        } else {
            $pdf->Cell(60, 5, $pdf->Image($uncheckedimg, $pdf->GetX() - 157, $pdf->GetY(), 4));
        }
        $pdf->SetX(47);
        $pdf->Cell(0, 4, utf8_decode('Kimik'), 0, 0, 'L');
        if ($dataser[0]["pershkrimiproblemit"] != null) {
            if (str_contains($dataser[0]["pershkrimiproblemit"], 'operimi')) {
                $pdf->Cell(60, 5, $pdf->Image($checkedimg, $pdf->GetX() - 125, $pdf->GetY(), 4));
            } else {
                $pdf->Cell(60, 5, $pdf->Image($uncheckedimg, $pdf->GetX() - 125, $pdf->GetY(), 4));
            }
        } else {
            $pdf->Cell(60, 5, $pdf->Image($uncheckedimg, $pdf->GetX() - 125, $pdf->GetY(), 4));
        }
        $pdf->SetX(79);
        $pdf->Cell(0, 4, utf8_decode(' Programi/ operimi'), 0, 0, 'L');
        if ($dataser[0]["pershkrimiproblemit"] != null) {
            if (str_contains($dataser[0]["pershkrimiproblemit"], 'Procedurë')) {
                $pdf->Cell(60, 5, $pdf->Image($checkedimg, $pdf->GetX() - 84, $pdf->GetY(), 4));
            } else {
                $pdf->Cell(60, 5, $pdf->Image($uncheckedimg, $pdf->GetX() - 84, $pdf->GetY(), 4));
            }
        } else {
            $pdf->Cell(60, 5, $pdf->Image($uncheckedimg, $pdf->GetX() - 84, $pdf->GetY(), 4));
        }
        $pdf->SetX(120);
        $pdf->Cell(0, 4, utf8_decode('Procedurë'), 0, 0, 'L');
        if ($dataser[0]["pershkrimiproblemit"] != null) {
            if (str_contains($dataser[0]["pershkrimiproblemit"], 'Tjetër')) {
                $pdf->Cell(60, 5, $pdf->Image($checkedimg, $pdf->GetX() - 46, $pdf->GetY(), 4));
            } else {
                $pdf->Cell(60, 5, $pdf->Image($uncheckedimg, $pdf->GetX() - 46, $pdf->GetY(), 4));
            }
        } else {
            $pdf->Cell(60, 5, $pdf->Image($uncheckedimg, $pdf->GetX() - 46, $pdf->GetY(), 4));
        }
        $pdf->SetX(158);
        $pdf->Cell(0, 4, utf8_decode('Tjetër'), 0, 0, 'L');
        if ($dataser[0]["pershkrimiproblemit"] != null) {
            if (str_contains($dataser[0]["pershkrimiproblemit"], 'problem')) {
                $pdf->Cell(60, 5, $pdf->Image($checkedimg, $pdf->GetX() - 21, $pdf->GetY(), 4));
            } else {
                $pdf->Cell(60, 5, $pdf->Image($uncheckedimg, $pdf->GetX() - 21, $pdf->GetY(), 4));
            }
        } else {
            $pdf->Cell(60, 5, $pdf->Image($uncheckedimg, $pdf->GetX() - 21, $pdf->GetY(), 4));
        }
        $pdf->SetX(181);
        $pdf->Cell(0, 4, utf8_decode('  Nuk u raportua'), 0, 0, 'L');

        $pdf->Ln();
        $pdf->SetFont('Times', '', 12);
        $pdf->Cell(0, 20, utf8_decode('LLOJI I VIZITËS'), 0, 0, 'L');
        $pdf->Ln();
        $pdf->SetFont('Times', 'B', 10);
        $pdf->SetLineWidth(0.4);
        $pdf->SetDrawColor(211, 211, 211);
        $pdf->Line(204, 153, 6, 153);
        if ($dataser[0]["llojivizites"] != null) {
            if (str_contains($dataser[0]["llojivizites"], 'Mirëmbajtje')) {
                $pdf->Cell(40, 5, $pdf->Image($checkedimg, $pdf->GetX() - 4, $pdf->GetY(), 4));
            } else {
                $pdf->Cell(40, 5, $pdf->Image($uncheckedimg, $pdf->GetX() - 4, $pdf->GetY(), 4));
            }
        } else {
            $pdf->Cell(40, 5, $pdf->Image($uncheckedimg, $pdf->GetX() - 4, $pdf->GetY(), 4));
        }
        $pdf->SetX(10);
        $pdf->Cell(0, 4, utf8_decode('Mirëmbajtje'), 0, 0, 'L');
        if ($dataser[0]["llojivizites"] != null) {
            if (str_contains($dataser[0]["llojivizites"], 'Urgjent')) {
                $pdf->Cell(60, 5, $pdf->Image($checkedimg, $pdf->GetX() - 157, $pdf->GetY(), 4));
            } else {
                $pdf->Cell(60, 5, $pdf->Image($uncheckedimg, $pdf->GetX() - 157, $pdf->GetY(), 4));
            }
        } else {
            $pdf->Cell(60, 5, $pdf->Image($uncheckedimg, $pdf->GetX() - 157, $pdf->GetY(), 4));
        }
        $pdf->SetX(47);
        $pdf->Cell(0, 4, utf8_decode('Urgjent'), 0, 0, 'L');
        if ($dataser[0]["llojivizites"] != null) {
            if (str_contains($dataser[0]["llojivizites"], 'Trajnim')) {
                $pdf->Cell(60, 5, $pdf->Image($checkedimg, $pdf->GetX() - 125, $pdf->GetY(), 4));
            } else {
                $pdf->Cell(60, 5, $pdf->Image($uncheckedimg, $pdf->GetX() - 125, $pdf->GetY(), 4));
            }
        } else {
            $pdf->Cell(60, 5, $pdf->Image($uncheckedimg, $pdf->GetX() - 125, $pdf->GetY(), 4));
        }
        $pdf->SetX(79);
        $pdf->Cell(0, 4, utf8_decode('Trajnim'), 0, 0, 'L');
        if ($dataser[0]["llojivizites"] != null) {
            if (str_contains($dataser[0]["llojivizites"], 'Instalim')) {
                $pdf->Cell(60, 5, $pdf->Image($checkedimg, $pdf->GetX() - 84, $pdf->GetY(), 4));
            } else {
                $pdf->Cell(60, 5, $pdf->Image($uncheckedimg, $pdf->GetX() - 84, $pdf->GetY(), 4));
            }
        } else {
            $pdf->Cell(60, 5, $pdf->Image($uncheckedimg, $pdf->GetX() - 84, $pdf->GetY(), 4));
        }
        $pdf->SetX(120);
        $pdf->Cell(0, 4, utf8_decode('Instalim'), 0, 0, 'L');
        if ($dataser[0]["llojivizites"] != null) {
            if (str_contains($dataser[0]["llojivizites"], 'Tjetërvz')) {
                $pdf->Cell(60, 5, $pdf->Image($checkedimg, $pdf->GetX() - 46, $pdf->GetY(), 4));
            } else {
                $pdf->Cell(60, 5, $pdf->Image($uncheckedimg, $pdf->GetX() - 46, $pdf->GetY(), 4));
            }
        } else {
            $pdf->Cell(60, 5, $pdf->Image($uncheckedimg, $pdf->GetX() - 46, $pdf->GetY(), 4));
        }
        $pdf->SetX(158);
        $pdf->Cell(0, 4, utf8_decode('Tjetër'), 0, 0, 'L');

        $pdf->Ln();
        $pdf->SetFont('Times', '', 12);
        $pdf->Cell(0, 20, utf8_decode('DETAJE'), 0, 0, 'L');
        $pdf->Ln();
        $pdf->SetFont('Times', 'B', 10);
        $pdf->SetLineWidth(0.4);
        $pdf->SetDrawColor(211, 211, 211);
        $pdf->Line(204, 178, 6, 178);


        $pdf->SetXY(10, 180);
        $pdf->SetFont('Times', 'B', 10);

        $pdf->Cell(25, 4, utf8_decode('Data sot'), 0, 0, 'L');
        $pdf->SetXY(10, 187);
        $pdf->SetFont('Times', '', 10);
        $pdf->Cell(25, 6, utf8_decode($dataser[0]["datasot"]), 'B', 0, 'L');


        $pdf->SetXY(47, 180);
        $pdf->SetFont('Times', 'B', 10);

        $pdf->Cell(25, 4, utf8_decode('Koha e ardhjes'), 0, 0, 'L');

        $pdf->SetXY(47, 187);
        $pdf->SetFont('Times', '', 10);

        $pdf->Cell(25, 6, utf8_decode($dataser[0]["kohaardhjes"]), 'B', 0, 'L');

        $pdf->SetXY(79, 180);
        $pdf->SetFont('Times', 'B', 10);

        $pdf->Cell(25, 4, utf8_decode('Koha e largimit'), 0, 0, 'L');

        $pdf->SetXY(79, 187);
        $pdf->SetFont('Times', '', 10);

        $pdf->Cell(25, 6, utf8_decode($dataser[0]["kohalargimit"]), 'B', 0, 'L');

        $pdf->SetXY(120, 180);
        $pdf->SetFont('Times', 'B', 10);

        $pdf->Cell(25, 4, utf8_decode('Trajnim'), 0, 0, 'L');

        $pdf->SetXY(120, 187);
        $pdf->SetFont('Times', '', 10);

        $pdf->Cell(25, 6, utf8_decode($dataser[0]["Trajnim"]), 'B', 0, 'L');

        $pdf->SetXY(153, 180);
        $pdf->SetFont('Times', 'B', 10);

        $pdf->Cell(25, 4, utf8_decode('Instalim'), 0, 0, 'L');

        $pdf->SetXY(153, 187);
        $pdf->SetFont('Times', '', 10);

        $pdf->Cell(25, 6, utf8_decode($dataser[0]["Instalim"]), 'B', 0, 'L');

        $pdf->SetXY(181, 180);
        $pdf->SetFont('Times', 'B', 10);

        $pdf->Cell(25, 4, utf8_decode('Tjetër'), 0, 0, 'L');

        $pdf->SetXY(181, 187);
        $pdf->SetFont('Times', '', 10);

        $pdf->Cell(25, 6, utf8_decode($dataser[0]["Tjetërdetaje"]), 'B', 0, 'L');

        $pdf->SetFont('Times', 'B', 10);
        //   $pdf->Ln();
        $pdf->SetXY(10, 198);
        $pdf->Cell(25, 4, utf8_decode('Koha në kompani'), 0, 0, 'L');
        $pdf->SetXY(10, 205);
        $pdf->SetFont('Times', '', 10);

        $pdf->Cell(25, 6, utf8_decode($dataser[0]["Kohakompani"]), 'B', 0, 'L');

        $pdf->SetFont('Times', 'B', 10);

        $pdf->SetXY(47, 198);
        $pdf->Cell(25, 4, utf8_decode('Koha në laborator'), 0, 0, 'L');

        $pdf->SetXY(47, 205);
        $pdf->SetFont('Times', '', 10);

        $pdf->Cell(25, 6, utf8_decode($dataser[0]["Kohalab"]), 'B', 0, 'L');
        $pdf->SetFont('Times', 'B', 10);

        $pdf->SetXY(79, 198);
        $pdf->Cell(25, 4, utf8_decode('Koha e udhëtimit'), 0, 0, 'L');

        $pdf->SetXY(79, 205);
        $pdf->SetFont('Times', '', 10);

        $pdf->Cell(25, 6, utf8_decode($dataser[0]["Kohaudhe"]), 'B', 0, 'L');

        $pdf->SetXY(120, 198);
        $pdf->SetFont('Times', 'B', 10);

        $pdf->Cell(25, 4, utf8_decode('Faturime'), 0, 0, 'L');

        $pdf->SetXY(120, 205);
        $pdf->SetFont('Times', '', 10);

        $pdf->Cell(25, 6, utf8_decode($dataser[0]["Faturime"]), 'B', 0, 'L');

        $pdf->SetXY(153, 198);
        $pdf->SetFont('Times', 'B', 10);

        $pdf->Cell(25, 4, utf8_decode('TT'), 0, 0, 'L');

        $pdf->SetXY(153, 205);
        $pdf->SetFont('Times', '', 10);

        $pdf->Cell(25, 6, utf8_decode($dataser[0]["TT"]), 'B', 0, 'L');

        $pdf->SetXY(181, 198);
        $pdf->SetFont('Times', 'B', 10);

        $pdf->Cell(25, 4, utf8_decode('Numri i faturës'), 0, 0, 'L');

        $pdf->SetXY(181, 205);
        $pdf->SetFont('Times', '', 10);

        $pdf->Cell(25, 6, utf8_decode($dataser[0]["Numrifatures"]), 'B', 0, 'L');
        $mk = substr_count($materialekonsumi, "\n");
        $sv = substr_count($Shenimevizit, "\n");
        $mlength = strlen($materialekonsumi);
        $slength = strlen($Shenimevizit);
        if ($slength > 252  || $mlength > 252  || $mk > 4 || $sv > 4) {
            $pdf->newp();
        } else {

            $pdf->Ln();

            $pdf->SetFont('Times', '', 12);
            $pdf->Cell(0, 20, utf8_decode('PËRSHKRIMI I PUNIMEVE'), 0, 0, 'L');
            $pdf->Ln();
            $pdf->SetFont('Times', 'B', 10);
            $pdf->SetLineWidth(0.4);
            $pdf->SetDrawColor(211, 211, 211);
            $pdf->Line(204, 225, 6, 225);
            $pdf->SetXY(10, 226);
            $pdf->Cell(25, 4, utf8_decode('Përshkrimi i punimeve'), 0, 0, 'L');
            $pdf->SetXY(10, 228);
            $pdf->SetFont('Times', '', 10);
            $pdf->MultiCell(95, 6, utf8_decode($dataser[0]["pershkrimipunes"]), 'B',  'L', false);
            $pdf->SetFont('Times', 'B', 10);
            $pdf->SetXY(110, 226);
            $pdf->Cell(25, 4, utf8_decode('Teste të kryera:'), 0, 0, 'L');
            $pdf->SetXY(110, 228);
            $pdf->SetFont('Times', '', 10);
            $pdf->MultiCell(40, 6, utf8_decode($dataser[0]["Testetekryera"]), 'B',  'L', false);
            $pdf->SetFont('Times', 'B', 10);
            $pdf->SetXY(160, 226);
            $pdf->Cell(25, 4, utf8_decode('Koha:'), 0, 0, 'L');
            $pdf->SetXY(160, 228);
            $pdf->SetFont('Times', '', 10);
            $pdf->MultiCell(44, 6, utf8_decode($dataser[0]["kohapershkrim"]), 'B',  'L', false);
            if ($dataser[0]["Aparaticheck"] == 1) {
                $pdf->Cell(40, 5, $pdf->Image($checkedimg, $pdf->GetX(), $pdf->GetY() + 2, 4));
            } else {
                $pdf->Cell(40, 5, $pdf->Image($uncheckedimg, $pdf->GetX(), $pdf->GetY() + 2, 4));
            }
            $pdf->SetXY(15, $pdf->GetY() + 2);
            $pdf->Cell(0, 4, utf8_decode('Aparati u dorëzua në gjendje të mirë pune'), 0, 0, 'L');
            $pdf->SetXY(10, 240);
            $pdf->SetFont('Times', 'B', 10);
            $pdf->Cell(25, 4, utf8_decode('Shënime për vizitën tjetër '), 0, 0, 'L');
            $pdf->SetXY(10, 244);
            $pdf->SetFont('Times', '', 10);
            $pdf->MultiCell(95, 4, utf8_decode($dataser[0]["Shenimevizit"]), 'B',  'L', false);
            $pdf->SetXY(110, 240);
            $pdf->SetFont('Times', 'B', 10);
            $pdf->Cell(25, 4, utf8_decode('Pjesë/materiale konsumi...'), 0, 0, 'L');
            $pdf->SetXY(110, 244);
            $pdf->SetFont('Times', '', 10);
            $pdf->MultiCell(95, 4, utf8_decode($dataser[0]["materialekonsumi"]), 'B',  'L', false);
        }
    }
    $pdf->Output('I', "Kerkesa.pdf");
} else {
    header("location:../logout.php");
}
