<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class ClientController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function checksession(){
          
        $res['success'] = true;
        $res['message'] = 'Sesioni aktiv';
        $res['code'] = '200';
        return response($res, 200);
    }
    public function klienti(Request $request)
    {
        $emri = $request->emriinstitutit;
        $nrbiznesit = $request->nrbiznesit;
        $veprimi = $request->veprimi;
        $id = $request->id;
        $qyteti = $request->qyteti;
        if ($veprimi == 'update') {
            if (empty($emri) || empty($emri) || empty($emri) || empty($emri) || empty($emri) || empty($emri)) {
                # code...
            }
        }
        try {
            $crudclient = DB::select(
                'call Klienti(?,?,?,?,?)',
                [$emri, $nrbiznesit, $veprimi, $id, $qyteti]
            );


            return response($crudclient, 200);
        } catch (\Illuminate\Database\QueryException $ex) {
            $res['success'] = false;
            //  $ex->getMessage() per me shfaq qfar gabimi 
            $res['message'] =   "Error";
            return response($res, 500);
        }
    }

    public function updklienti(Request $request)
    {
        $id = $request->id;
        $emri = $request->emriinstitutit;
        $nrbiznesit = $request->nrbiznesit;
        $nrfiskal = $request->nrfiskal;
        $adresa = $request->adresa;
        $qyteti = $request->qyteti;
        $email = $request->email;

        if (empty($id) || empty($emri) || empty($nrbiznesit) || empty($nrfiskal) || empty($adresa) || empty($qyteti)) {
            $res['success'] = false;
            $res['message'] =   "Të plotësohen të gjitha fushat";
            return response($res, 422);
        }

        try {
            $crudclient = DB::table('tbl_institucioni')->where('id', $id)  // find your user by their email
                ->limit(1)  // optional - to ensure only one record is updated.
                ->update([
                    'emri_institutit' => $emri,
                    'numri_biznesit' => $nrbiznesit,
                    'qyteti' => $qyteti,
                    'adressa' => $adresa,
                    'nr_fiskal' => $nrfiskal,
                    'email' => $email
                ]);

            return response($crudclient, 200);
        } catch (\Illuminate\Database\QueryException $ex) {
            $res['success'] = false;
            //  $ex->getMessage() per me shfaq qfar gabimi 
            $res['message'] =   "Error";
            return response($res, 500);
        }
    }

    public function servicepdf(Request $request)
    {
        $foto = $request->foto;
        $kodi = $request->kodi;
        $nrfaqev = $request->nrfaqev;
        $titulli = $request->titulli;
        $versioni = $request->versioni;

        try {
            $del = DB::table('pdfservisim')->delete();
            $in =   DB::table('pdfservisim')->insert(
                [
                    'foto' => $foto,
                    'Titulli' => $titulli,
                    'Versioni' => $versioni,
                    'Kodi' => $kodi,
                    'NrFaqev' => $nrfaqev
                ]
            );


            return response('Sukses', 200);
        } catch (\Illuminate\Database\QueryException $ex) {
            $res['success'] = false;
            //  $ex->getMessage() per me shfaq qfar gabimi 
            $res['message'] =   "Error";
            return response($res, 500);
        }
    }
    public function getservicepdf()
    {
        $products = DB::table('pdfservisim')->get();
        if (empty($products)) {
            $arr = array('code' => 404, 'data' => []);
            echo json_encode($arr);
        } else {
            $countallproducts = count($products);
            if ($countallproducts > 0) {
                return response()->json(array(
                    'code' => 200,
                    'data' => $products
                ), 200);
            }
        }
    
    }
    public function porosipdf(Request $request)
    {
        $foto = $request->foto;
        $kodi = $request->kodi;
        $nrfaqev = $request->nrfaqev;
        $titulli = $request->titulli;
        $versioni = $request->versioni;

        try {
            $del = DB::table('pdfporosi')->delete();
            $in =   DB::table('pdfporosi')->insert(
                [
                    'foto' => $foto,
                    'Titulli' => $titulli,
                    'Versioni' => $versioni,
                    'Kodi' => $kodi,
                    'NrFaqev' => $nrfaqev
                ]
            );


            return response('Sukses', 200);
        } catch (\Illuminate\Database\QueryException $ex) {
            $res['success'] = false;
            //  $ex->getMessage() per me shfaq qfar gabimi 
            $res['message'] =   "Error";
            return response($res, 500);
        }
    }
    public function getporosipdf()
    {
        $products = DB::table('pdfporosi')->get();
        if (empty($products)) {
            $arr = array('code' => 404, 'data' => []);
            echo json_encode($arr);
        } else {
            $countallproducts = count($products);
            if ($countallproducts > 0) {
                return response()->json(array(
                    'code' => 200,
                    'data' => $products
                ), 200);
            }
        }
    
    }
}
