<?php
session_start();
if (isset($_SESSION['_session']['user'])) {
  header("location: index/panel/dashboard.php");
  exit;
}
?>
<!DOCTYPE html>
<html>

<head>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <meta name="description" content="Atommed Service">
  <meta name="robots" content="Atommed Service, Atommed, Service, Medical, Laboratory, Devices, Equipment">
  <meta name="googlebot" content="Atommed Service, Atommed, Service, Medical, Laboratory, Devices, Equipment">
  <meta name="robots" content="max-snippet:0">
  <link rel="apple-touch-icon" sizes="180x180" href="images/Atommedicon.png">
  <link rel="icon" type="image/png" href="extras/images/Atommedicon.png">

  <link rel="stylesheet" type="text/css" href="extras/style.css">
  <link rel="stylesheet" type="text/css" href="extras/slider/bxSlider.css">
  <link rel="stylesheet" type="text/css" href="extras/fontawesome/all.min.css">
  <link rel="stylesheet" type="text/css" href="extras/fontawesome/fontawesome.min.css">
  <link rel="stylesheet" type="text/css" href="extras/fontawesome/solid.min.css">

  <title>Log In | Atommed - Service</title>

  <style type="text/css">
    /* Set a style for all buttons */

    body {
      margin: 0px;
      background-image: url(extras/images/labimg2.jpg);
      background-repeat: no-repeat;
      background-size: cover;
    }

    .beforeModal {
      margin-left: 20px;
      margin-right: 20px;
      width: 400px;
    }

    button {
      background-color: #04AA6D;
      color: white;
      padding: 14px 20px;
      margin: 8px 0;
      border: none;
      cursor: pointer;
      width: 100%;
      border-radius: 6px;
    }

    button:hover {
      opacity: 0.8;
    }

    .avatarRight {
      max-height: 65px;
      max-width: 231px;
      object-fit: contain;
    }

    .topDiv {
      height: 100vh;
      display: grid;
      grid-template-columns: 30% 70%;
      transition: all .3s;
    }

    .modal-content {
      box-shadow: 0 0 10px #00000096;
    }

    .leftDiv {
      display: grid;
      place-content: center;
      background: linear-gradient(90deg, #04aa6dba, #04aa91ba, #179f8bba, #0499aaba, #047baaba, #2685c7ba);
      backdrop-filter: blur(1px);
      box-shadow: 1px 0px 5px black;
      position: relative;
      background-size: 400% 400%;
      animation: gradient 10s ease infinite;
      height: 100vh;
    }

    @keyframes gradient {
      0% {
        background-position: 0% 50%;
      }

      50% {
        background-position: 100% 50%;
      }

      100% {
        background-position: 0% 50%;
      }
    }

    .leftDiv>* {
      margin-left: 25px;
      margin-right: 25px;
    }

    .rightDiv {
      /* min-height: 100vh; */
      margin: 0;
      background-position: center;
      display: grid;
      place-content: center;
      grid-template-columns: 100%;
    }

    .rightDiv>.rightDivFirst {
      width: 100%;
      height: 100vh;
      backdrop-filter: brightness(0.3);
      display: grid;
      grid-template-columns: 100%;
      place-content: center;
    }

    .rightDiv .rightDivSecond {
      width: 68%;
      display: none;
      /* display: flex; */
      justify-content: space-between;
      position: fixed;
      bottom: 0px;
      background-color: #16555a7a;
      padding: 10px 1% 10px 1%;
    }

    .rightDiv .rightDivSecond a {
      color: white;
      text-decoration: none;
      font-size: 17px;
      transition: all .3s;
    }

    .rightDiv .rightDivSecond a:hover {
      color: #00e86d;
      text-decoration: none;
      font-size: 17px;
      transition: all .3s;
    }

    .rightDiv h1 {
      color: white;
      text-transform: uppercase;
    }

    .leftDiv .leftDivSecond {
      display: none;
    }

    .inputsIcon {
      margin-left: 5px;
      margin-right: 5px;
    }

    .wrongIcon {
      color: #cd5555;
    }

    @media screen and (max-width: 1500px) {
      .leftDiv {
        background: transparent;
      }

      .leftDiv .leftDivSecond {
        width: 100%;
        margin: 0px;
        display: grid;
        grid-template-columns: auto auto auto auto;
        row-gap: 20px;
        padding: 10px 0px;
        text-align: center;
        position: fixed;
        bottom: 0px;
        background-color: #00000078;
      }

      .leftDiv .leftDivSecond a {
        color: white;
        text-decoration: none;
        font-size: 17px;
        transition: all .3s;
      }

      .leftDiv .leftDivSecond a:hover {
        color: #00e86d;
        text-decoration: none;
        font-size: 17px;
        transition: all .3s;
      }

      .topDiv {
        height: 100vh;
        display: grid;
        grid-template-columns: 100% !important;
        transition: all .3s;
      }

      .beforeModal {
        display: grid;
        justify-content: center;
      }

      .modal-content {
        backdrop-filter: blur(2px) brightness(0.6);
        width: 400px;
        /* margin: 20px; */
      }

      .leftDiv {
        /* background-image: url(images/bg3.jpg); */
        background-size: cover;
        background-color: transparent;
        backdrop-filter: brightness(0.3);
      }

      .rightDiv {
        display: none !important;
      }
    }

    @media screen and (max-width: 1200px) {
      .leftDiv .leftDivSecond {
        display: grid;
        grid-template-columns: 50% 50%;
      }
    }

    @media screen and (max-width: 575px) {
      .leftDiv .leftDivSecond {
        display: grid;
        grid-template-columns: 100%;
        row-gap: 20px;
        padding: 20px 0px;
      }
    }

    @media screen and (max-width: 453px) {
      .modal-content {
        width: 320px;
        margin-left: 0px;
        margin-right: 0px;
      }

      .leftDiv>* {
        margin: 0px;
        width: 100%;
      }
    }

    @media screen and (max-width:402px) {
      .modal-content {
        width: 270px;
        margin-left: 0px;
        margin-right: 0px;
      }

      .leftDiv>* {
        margin: 0px;
        width: 100%;
      }
    }

    @media screen and (max-width:375px) {
      .modal-content {
        width: 300px;
        margin-left: 0px;
        margin-right: 0px;
      }

      .leftDiv>* {
        margin: 0px;
        width: 100%;
      }
    }
  </style>
</head>

<body>
  <div class="topDiv">

    <div id="" class="leftDiv">
      <div class="beforeModal">
        <div class="modal-content animate">
          <div class="imgcontainer">
            <a href="https://www.atommed.net" title="Atommed"><img src="extras/images/Atommed.png" alt="Avatar" class="avatar"></a>
          </div>
          <div class="container">
            <label for="uname"><span class="fa-solid fa-user inputsIcon inputsIcon1"></span> Përdoruesi</label>
            <input type="text" placeholder="Shkruaj perdoruesin" id="txtuser" name="perdoruesi">
            <label for="psw"><span class="fa-solid fa-lock inputsIcon inputsIcon1"></span> Fjalëkalimi</label>
            <input type="password" placeholder="Shkruani Fjalëkalimin" id="txtpass" name="fjalekalimi">
            <button type="button" id="btnlogin" value="login" name="login_user">Kyçu <span class="fa-solid fa-chevron-right inputsIcon" style="font-size: 12px;"></span></button>
          </div>
        </div>
        <div class="alert hidden informasi" role="alert"></div>
        <div class="hidden capsLock" role="alert"></div>
      </div>

      <div class="leftDivSecond">
        <div class="RDS">
          <a href="tel:049530552"><span class="fa fa-phone inputsIcon"></span> +383 49 530 552</a>
        </div>
        <div class="RDS">
          <a href="mailto:atommed@hotmail.com"><span class="fa fa-envelope inputsIcon"></span> atommed@hotmail.com</a>
        </div>
        <div class="RDS">
          <a href="https://www.google.com/maps?ll=42.372362,21.144967&z=18&t=m&hl=en&gl=US&mapclient=embed&cid=3686715007290192932" target="_blank"><span class="fa fa-map inputsIcon"></span> Ramadan Rexhepi, Ferizaj 70000</a>
        </div>
        <div class="RDS">
          <a href="javascript:void(0);" style="cursor:default;"><span class="fa fa-clock inputsIcon"></span> 09:00 - 17:00 (Hëne - Premte)</a>
        </div>
      </div>
    </div>

    <div class="rightDiv">
      <div class="rightDivFirst">
        <a href="https://www.atommed.net" title="Atommed" style="display: flex; justify-content:center;margin-bottom: 30px;"><img src="extras/images/Atommed.png" alt="Avatar" class="avatarRight"></a>

        <div id="slider" class="owl-theme">
          <h1>Zgjidhje mjekësore</h1>
          <h1>Pajisje mjekësore dhe automatizim</h1>
          <h1>Kujdes i përmirësuar ndaj pacientit</h1>
        </div>
      </div>

      <div class="rightDivSecond">
        <div class="RDS">
          <a href="tel:049530552"><span class="fa fa-phone inputsIcon"></span> +383 49 530 552</a>
        </div>
        <div class="RDS">
          <a href="mailto:atommed@hotmail.com"><span class="fa fa-envelope inputsIcon"></span> atommed@hotmail.com</a>
        </div>
        <div class="RDS">
          <a href="https://www.google.com/maps?ll=42.372362,21.144967&z=18&t=m&hl=en&gl=US&mapclient=embed&cid=3686715007290192932" target="_blank"><span class="fa fa-map inputsIcon"></span> Ramadan Rexhepi, Ferizaj 70000</a>
        </div>
        <div class="RDS">
          <a href="javascript:void(0);" style="cursor:default;"><span class="fa fa-clock inputsIcon"></span> 09:00 - 17:00 (Hëne - Premte)</a>
        </div>
      </div>
    </div>

  </div>

  <script type="text/javascript" src="extras/jquery/jquery.min.js"></script>
  <script type="text/javascript" src="extras/slider/bxSlider.min.js"></script>
  <script type="text/javascript" src="extras/fontawesome/all.min.js"></script>
  <script type="text/javascript" src="extras/fontawesome/fontawesome.min.js"></script>
  <script type="text/javascript" src="extras/fontawesome/solid.min.js"></script>
  <script type="text/javascript" src="index/panel/js/sha256.js"></script>

  <script>
    $(document).ready(function() {
      $('#slider').bxSlider({
        autoControls: true,
        auto: true,
        // pager: true,
        // slideWidth: 600,
        mode: 'fade',
        captions: true,
        speed: 500
      });
    });

    // document.getElementById('id01').style.display = 'block';
    var input = document.getElementById("txtpass");
    input.addEventListener("keyup", function(event) {

      if (event.keyCode === 13) {
        event.preventDefault();
        document.getElementById("btnlogin").click();
      }

      password = document.querySelector('#txtpass');

      password.addEventListener('keyup', function(event) {
        $(".informasi").addClass("hidden").removeClass('wrong').html('');
        $(".modal-content").removeClass('wrongDiv');
        $(".inputsIcon1").removeClass('wrongIcon');
        if (event.getModifierState('CapsLock')) {
          $(this).css('background-color', '#fffde4a6');
          $(this).prev().find(".inputsIcon1").css('color', '#b38127');
          $(".capsLock").removeClass("hidden").addClass('caps').html('Caps Lock is <strong>ON</strong> ');
        } else {
          $(this).css('background-color', '#ffffffb0');
          $(this).prev().find(".inputsIcon1").css('color', '#47614b');
          $(".capsLock").addClass("hidden").removeClass('caps').html('');
        }
      });
    });

    var input = document.getElementById("txtuser");
    input.addEventListener("keyup", function(event) {

      if (event.keyCode === 13) {
        event.preventDefault();
        document.getElementById("btnlogin").click();
      }

      username = document.querySelector('#txtuser');

      username.addEventListener('keyup', function(event) {
        $(".informasi").addClass("hidden").removeClass('wrong').html('');
        $(".modal-content").removeClass('wrongDiv');
        $(".inputsIcon1").removeClass('wrongIcon');
        if (event.getModifierState('CapsLock')) {
          $(this).css('background-color', '#fffde4a6');
          $(this).prev().find(".inputsIcon1").css('color', '#b38127');
          $(".capsLock").removeClass("hidden").addClass('caps').html('Caps Lock is <strong>ON</strong> ');
        } else {
          $(this).css('background-color', '#ffffffb0');
          $(this).prev().find(".inputsIcon1").css('color', '#47614b');
          $(".capsLock").addClass("hidden").removeClass('caps').html('');
        }
      });
    });

    $("#btnlogin").click(function() {
      var ajax = {
        user: $("#txtuser").val(),
        password: sha256($("#txtpass").val())
      }

      $.ajax({
        url: "http://localhost/atomi/thelogin/api/login",
        type: "POST",
        data: ajax,
        success: function(data, textStatus, jqXHR) {
          var ajax = {
            data: data
          }
          $.ajax({
            url: "index/set_authenticate.php",
            type: "POST",
            data: ajax,
            success: function(data, textStatus, jqXHR) {
              var data = jQuery.parseJSON(data);
              var red = data.url;
              window.location.replace(red);
              return false;

            },
            error: function(request, textStatus, errorThrown) {
              console.log(request);
            }
          });
        },
        error: function(request, textStatus, errorThrown) {
          $(".informasi").removeClass("hidden").addClass('wrong').html(request.responseJSON.message);
          $(".modal-content").addClass('wrongDiv');
          $(".inputsIcon1").addClass('wrongIcon');

          // $(".informasi").effect( "shake", {  times: 2, distance: 7}, 800);
        }
      });
    });
  </script>

</body>

</html>