<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class UserController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    //Done by Arda
    public function show($id)
    {
        $perdoruesit = DB::select('SELECT p.institucioni as inst_id, c.id as qyteti_id, p.id, p.perdoruesi, p.emri, p.mbiemri, p.data_e_lindjes, p.gjinia, p.adresa, p.nr_kontaktues, p.statusi, p.data, c.emri_qytetit, poz.pozitat, i.emri_institutit, i.numri_biznesit
        FROM perdoruesit p
        LEFT JOIN qyteti c
        ON p.adresa = c.id
        LEFT JOIN pozitat poz
        ON p.pozitat = poz.id
        LEFT JOIN tbl_institucioni i
        ON p.institucioni = i.id
        WHERE p.id = ' . $id . '');
        if (empty($perdoruesit)) {
            $arr = array('code' => 404, 'message' => 'No data found');
            echo json_encode($arr);
        } else {
            $countallperdoruesit = count($perdoruesit);
            if ($countallperdoruesit > 0) {
                return response()->json(array(
                    'code' => 200,
                    'data' => $perdoruesit
                ), 200);
            }
        }
    }

    public function getallusers()
    {
        $all_users = DB::select('SELECT p.id, p.perdoruesi, p.emri, p.mbiemri, p.data_e_lindjes, p.gjinia, p.adresa, p.nr_kontaktues, p.statusi, p.data, c.emri_qytetit, poz.pozitat, i.emri_institutit, i.numri_biznesit
        FROM perdoruesit p
        LEFT JOIN qyteti c
        ON p.adresa = c.id
        LEFT JOIN pozitat poz
        ON p.pozitat = poz.id
        LEFT JOIN tbl_institucioni i
        ON p.institucioni = i.id');
        if (empty($all_users)) {
            $arr = array(300);
            echo json_encode($arr);
        } else {
            $countallperdoruesit = count($all_users);
            if ($countallperdoruesit > 0) {
                return response()->json(

                    $all_users,

                );
            }
        }
    }

    public function getmyusers($institut)
    {
        $all_users = DB::select('SELECT p.id, p.perdoruesi, p.emri, p.mbiemri, p.data_e_lindjes, p.gjinia, p.adresa, p.nr_kontaktues, p.statusi, p.data, c.emri_qytetit, poz.pozitat, i.emri_institutit, i.numri_biznesit
        FROM perdoruesit p
        LEFT JOIN qyteti c
        ON p.adresa = c.id
        LEFT JOIN pozitat poz
        ON p.pozitat = poz.id
        LEFT JOIN tbl_institucioni i
        ON p.institucioni = i.id
        WHERE p.institucioni = ' . $institut);
        if (empty($all_users)) {
            $arr = array(300);
            echo json_encode($arr);
        } else {
            $countallperdoruesit = count($all_users);
            if ($countallperdoruesit > 0) {
                return response()->json(

                    $all_users,

                );
            }
        }
    }
    // end done by arda





    // done bu driloni per Procedure 
    public function perdoruesi(Request $request)
    {
        $veprimi = $request->veprimi;
        $id = $request->id;
        $perdoruesi = $request->perdoruesi;
        $fjalkalimi = $request->fjalkalimi;
        $pozita = $request->pozita;
        $emri = $request->emri;
        $mbiemri = $request->mbiemri;
        $datalindjes = $request->datalindjes;
        $gjinia = $request->gjinia;
        $adresa = $request->adresa;
        $institucioni = $request->institucioni;
        $nrkontakt = $request->nrkontakt;
        $statusi = $request->statusi;

        if ($veprimi == 'insert') {
            $emriins = $request->emriinstitutit;
            $nrbiznesit = $request->nrbiznesit;
            $adressa = $request->adressa;
            $nrfiskal = $request->nrfiskal;

            if (
                $request->perdoruesi == "" || is_null($request->perdoruesi) ||
                $request->fjalkalimi == "" || is_null($request->fjalkalimi) ||
                $request->pozita == "" || is_null($request->pozita)  ||
                $request->adresa == "" || is_null($request->adresa)  ||
                $request->nrfiskal == "" || is_null($request->nrfiskal)  ||
                $request->adressa == "" || is_null($request->adressa) ||
                $request->nrkontakt == "" || is_null($request->nrkontakt)
            ) {
                $res['success'] = false;
                $res['message'] = "Të plotësohen të gjitha fushat";
                return response($res, 422);
            }
            $ekziston = DB::table('perdoruesit')->where('perdoruesi', $perdoruesi)->first();
            if ($ekziston != null) {
                $res['success'] = false;
                $res['message'] = "Përdoruesi ekziston";
                return response($res, 491);
            }
            $pozita = 2;
            $emri = $emriins;
            $mbiemri = '';
            $datalindjes = '';
            $gjinia = '';
        }

        try {
            if ($veprimi == 'insert') {
                $insert = DB::insert(
                    "INSERT INTO `tbl_institucioni`(`emri_institutit`, `AdminID`, `numri_biznesit`, `qyteti`, `statusi`,adressa,nr_fiskal) VALUES (?,?,?,?,?,?,?)",
                    [$emriins, 0, $nrbiznesit, $adresa, $statusi, $adressa, $nrfiskal]
                );
                $_reg3 = DB::select("SELECT id from tbl_institucioni where emri_institutit='" . $emriins . "'");
                $selid3 = json_decode(json_encode($_reg3), true);
                $institucioni = $selid3[0]['id'];
            }
            $crudclient = DB::select(
                'CALL `Perdoruesit`(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)',
                [$veprimi, $id, $perdoruesi, $fjalkalimi, $pozita, $emri, $mbiemri, $datalindjes, $gjinia, $adresa, $institucioni, $nrkontakt, $statusi]
            );
            if ($veprimi == 'update') {
                $crudclient = 'Perditsim eshte bere me sukses';
            }
            if ($veprimi == 'insert') {

                $_reg2 = DB::select("SELECT id from Perdoruesit where perdoruesi='" . $perdoruesi . "'");
                $selid = json_decode(json_encode($_reg2), true);
                $insert = DB::update("UPDATE tbl_institucioni SET AdminID='" . $selid[0]['id'] . "' where emri_institutit='" . $emriins . "'");
                $rolidb = DB::select("SELECT * from pozitat where id='" . $pozita . "'");
                $rolidb = json_decode(json_encode($rolidb), true);
                $crudclient = DB::insert(
                    " INSERT INTO permmissions( perdoruesi_id, Dashboard, Profili_im, kerkesat_mine, parashtro_kerkese_servisi, Personeli, Harta, GjithPerdoruesit, GjithaKerkesatKlienteve, Kerkesat_Npritje, Kerkesat_Nprocesim, Kerkesat_Perfunduara, Shto_perdorues, Shiko_perdorues, edito_perdorues,fshij_perdorues,cakto_role,Klientet,Klientet_Npritje,Kerkesat_Anuluara,kerkesat_my_institut,Produktet_tona,user_profile,Furnitoret,Shiko_klient,Edito_klient,Shto_klient,Delete_klient,Shiko_pozite,Shto_pozite,Edito_pozite,Delete_pozite,Shiko_qytet,Shto_qytet,Edito_qytet,Delete_qytet, GjithaPorositeKlientve, Porosite_Npritje, Porosite_Nprocesim, Porosite_Anuluara, Porosite_Perfunduara, Porosite_my_institut, Porosite_mine, parashtro_porosi)
         VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)",
                    [
                        $selid[0]['id'], $rolidb[0]['Dashboard'], $rolidb[0]['Profili_im'], $rolidb[0]['kerkesat_mine'], $rolidb[0]['parashtro_kerkese_servisi'], $rolidb[0]['Personeli'], $rolidb[0]['Harta'], $rolidb[0]['GjithPerdoruesit'], $rolidb[0]['GjithaKerkesatKlienteve'], $rolidb[0]['Kerkesat_Npritje'], $rolidb[0]['Kerkesat_Nprocesim'], $rolidb[0]['Kerkesat_Perfunduara'], $rolidb[0]['Shto_perdorues'], $rolidb[0]['Shiko_perdorues'], $rolidb[0]['edito_perdorues'], $rolidb[0]['fshij_perdorues'], $rolidb[0]['cakto_role'], $rolidb[0]['Klientet'], $rolidb[0]['Klientet_Npritje'], $rolidb[0]['Kerkesat_Anuluara'], $rolidb[0]['kerkesat_my_institut'], $rolidb[0]['Produktet_tona'], $rolidb[0]['user_profile'], $rolidb[0]['Furnitoret'], $rolidb[0]['Shiko_klient'], $rolidb[0]['Edito_klient'], $rolidb[0]['Shto_klient'], $rolidb[0]['Delete_klient'], $rolidb[0]['Shiko_pozite'], $rolidb[0]['Shto_pozite'], $rolidb[0]['Edito_pozite'], $rolidb[0]['Delete_pozite'], $rolidb[0]['Shiko_qytet'], $rolidb[0]['Shto_qytet'], $rolidb[0]['Edito_qytet'], $rolidb[0]['Delete_qytet'], $rolidb[0]['GjithaPorositeKlientve'], $rolidb[0]['Porosite_Npritje'], $rolidb[0]['Porosite_Nprocesim'], $rolidb[0]['Porosite_Anuluara'], $rolidb[0]['Porosite_Perfunduara'], $rolidb[0]['Porosite_my_institut'], $rolidb[0]['Porosite_mine'], $rolidb[0]['parashtro_porosi']
                    ]
                );
            }


            return response($crudclient, 200);
        } catch (\Illuminate\Database\QueryException $ex) {
            $res['success'] = false;
            //  $ex->getMessage() per me shfaq qfar gabimi 
            $res['message'] = "Error";
            return response($res, 500);
        }
    }

    public function getlejet($id)
    {
        $lejet = DB::select('SELECT * from permmissions
        WHERE perdoruesi_id = ' . $id . '');
        if (empty($lejet)) {
            $arr = array(300);
            echo json_encode($arr);
        } else {
            $countalllejet = count($lejet);
            if ($countalllejet > 0) {
                return response()->json(
                    $lejet,
                );
            }
        }
    }

    public function updlejet(Request $request, $id)
    {

        $Dashboard = $request->Dashboard;
        $Profili_im = $request->Profili_im;
        $Harta = $request->Harta;
        $kerkesat_mine = $request->kerkesat_mine;
        $parashtro_kerkese_servisi = $request->parashtro_kerkese_servisi;
        $GjithaKerkesatKlienteve = $request->GjithaKerkesatKlienteve;
        $Kerkesat_Npritje = $request->Kerkesat_Npritje;
        $Kerkesat_Nprocesim = $request->Kerkesat_Nprocesim;
        $Kerkesat_Perfunduara = $request->Kerkesat_Perfunduara;
        $GjithPerdoruesit = $request->GjithPerdoruesit;
        $Personeli = $request->Personeli;
        $Shto_perdorues = $request->Shto_perdorues;
        $Shiko_perdorues = $request->Shiko_perdorues;
        $edito_perdorues = $request->edito_perdorues;
        $fshij_perdorues = $request->fshij_perdorues;
        $cakto_role = $request->cakto_role;
        $Klientet = $request->Klientet;
        $Klientet_Npritje = $request->Klientet_Npritje;
        $Kerkesat_Anuluara = $request->Kerkesat_Anuluara;
        $kerkesat_my_institut = $request->kerkesat_my_institut;
        $Produktet_tona = $request->Produktet_tona;
        $user_profile = $request->user_profile;
        $Furnitoret = $request->Furnitoret;
        $Shiko_klient = $request->Shiko_klient;
        $Edito_klient = $request->Edito_klient;
        $Shto_klient = $request->Shto_klient;
        $Delete_klient = $request->Delete_klient;
        $Shiko_pozite = $request->Shiko_pozite;
        $Shto_pozite = $request->Shto_pozite;
        $Edito_pozite = $request->Edito_pozite;
        $Delete_pozite = $request->Delete_pozite;
        $Edito_qytet = $request->Edito_qytet;
        $Shiko_qytet = $request->Shiko_qytet;
        $Delete_qytet = $request->Delete_qytet;
        $Shto_qytet = $request->Shto_qytet;
        $GjithaPorositeKlientve = $request->GjithaPorositeKlientve;
        $Porosite_Npritje = $request->Porosite_Npritje;
        $Porosite_Nprocesim = $request->Porosite_Nprocesim;
        $Porosite_Anuluara = $request->Porosite_Anuluara;
        $Porosite_Perfunduara = $request->Porosite_Perfunduara;
        $Porosite_my_institut = $request->Porosite_my_institut;
        $Porosite_mine = $request->Porosite_mine;
        $parashtro_porosi = $request->parashtro_porosi;
        try {
            $_reg = DB::update("UPDATE `permmissions` SET `Dashboard`='$Dashboard',`Profili_im`='$Profili_im',`kerkesat_mine`='$kerkesat_mine',
            `parashtro_kerkese_servisi`='$parashtro_kerkese_servisi',`Harta`='$Harta',`GjithaKerkesatKlienteve`='$GjithaKerkesatKlienteve',`Kerkesat_Npritje`='$Kerkesat_Npritje',`Kerkesat_Nprocesim`='$Kerkesat_Nprocesim',
            `Kerkesat_Perfunduara`='$Kerkesat_Perfunduara',`GjithPerdoruesit`='$GjithPerdoruesit',`Personeli`='$Personeli',`Shto_perdorues`='$Shto_perdorues',`Shiko_perdorues`='$Shiko_perdorues',
            `edito_perdorues`='$edito_perdorues',`fshij_perdorues`='$fshij_perdorues',`cakto_role`='$cakto_role',`Klientet`='$Klientet',`Klientet_Npritje`='$Klientet_Npritje',
            `Kerkesat_Anuluara`='$Kerkesat_Anuluara',`kerkesat_my_institut`='$kerkesat_my_institut',`Produktet_tona`='$Produktet_tona',`user_profile`='$user_profile',`Furnitoret`='$Furnitoret',
            `Shiko_klient`='$Shiko_klient',`Edito_klient`='$Edito_klient',`Shto_klient`='$Shto_klient',`Delete_klient`='$Delete_klient',`Shiko_pozite`='$Shiko_pozite',`Shto_pozite`='$Shto_pozite',
            `Edito_pozite`='$Edito_pozite',`Delete_pozite`='$Delete_pozite',`Shiko_qytet`='$Shiko_qytet',`Shto_qytet`='$Shto_qytet',`Edito_qytet`='$Edito_qytet',`Delete_qytet`='$Delete_qytet' ,
            `GjithaPorositeKlientve`='$GjithaPorositeKlientve',`Porosite_Npritje`='$Porosite_Npritje',`Porosite_Nprocesim`='$Porosite_Nprocesim',`Porosite_Anuluara`='$Porosite_Anuluara',`Porosite_Perfunduara`='$Porosite_Perfunduara',`Porosite_my_institut`='$Porosite_my_institut', `Porosite_mine`='$Porosite_mine',`parashtro_porosi`='$parashtro_porosi' WHERE perdoruesi_id=" . $id . "");

            $res['success'] = true;
            $res['message'] = "Lejet e Userit u ndryshuan me sukses! ";
            return response($res, 200);
        } catch (\Illuminate\Database\QueryException $ex) {
            $res['success'] = false;
            $res['message'] = "Error";
            return response($res, 500);
        }
    }
    public function insertnewroli(Request $request)
    {
        $pozitat = $request->pozitat;

        $Dashboard = $request->Dashboard;
        $Profili_im = $request->Profili_im;
        $Harta = $request->Harta;
        $kerkesat_mine = $request->kerkesat_mine;
        $parashtro_kerkese_servisi = $request->parashtro_kerkese_servisi;
        $GjithaKerkesatKlienteve = $request->GjithaKerkesatKlienteve;
        $Kerkesat_Npritje = $request->Kerkesat_Npritje;
        $Kerkesat_Nprocesim = $request->Kerkesat_Nprocesim;
        $Kerkesat_Perfunduara = $request->Kerkesat_Perfunduara;
        $GjithPerdoruesit = $request->GjithPerdoruesit;
        $Personeli = $request->Personeli;
        $Shto_perdorues = $request->Shto_perdorues;
        $Shiko_perdorues = $request->Shiko_perdorues;
        $edito_perdorues = $request->edito_perdorues;
        $fshij_perdorues = $request->fshij_perdorues;
        $cakto_role = $request->cakto_role;
        $Klientet = $request->Klientet;
        $Klientet_Npritje = $request->Klientet_Npritje;
        $Kerkesat_Anuluara = $request->Kerkesat_Anuluara;
        $kerkesat_my_institut = $request->kerkesat_my_institut;
        $Produktet_tona = $request->Produktet_tona;
        $user_profile = $request->user_profile;
        $Furnitoret = $request->Furnitoret;
        $Shiko_klient = $request->Shiko_klient;
        $Edito_klient = $request->Edito_klient;
        $Shto_klient = $request->Shto_klient;
        $Delete_klient = $request->Delete_klient;
        $Shiko_pozite = $request->Shiko_pozite;
        $Shto_pozite = $request->Shto_pozite;
        $Edito_pozite = $request->Edito_pozite;
        $Delete_pozite = $request->Delete_pozite;
        $Edito_qytet = $request->Edito_qytet;
        $Shiko_qytet = $request->Shiko_qytet;
        $Delete_qytet = $request->Delete_qytet;
        $Shto_qytet = $request->Shto_qytet;
        $statusi = $request->statusi;
        $GjithaPorositeKlientve = $request->GjithaPorositeKlientve;
        $Porosite_Npritje = $request->Porosite_Npritje;
        $Porosite_Nprocesim = $request->Porosite_Nprocesim;
        $Porosite_Anuluara = $request->Porosite_Anuluara;
        $Porosite_Perfunduara = $request->Porosite_Perfunduara;
        $Porosite_my_institut = $request->Porosite_my_institut;
        $Porosite_mine = $request->Porosite_mine;
        $parashtro_porosi = $request->parashtro_porosi;

        try {
            $_reg = DB::insert(
                "INSERT INTO `pozitat`( `statusi`, `pozitat`, `Dashboard`, `Profili_im`, `Harta`, `kerkesat_mine`, `parashtro_kerkese_servisi`, `GjithaKerkesatKlienteve`, `Kerkesat_Npritje`, `Kerkesat_Nprocesim`, `Kerkesat_Perfunduara`, `GjithPerdoruesit`, `Personeli`, `Shto_perdorues`, `Shiko_perdorues`, `edito_perdorues`, `fshij_perdorues`, `cakto_role`, `Klientet`, `Klientet_Npritje`, `Kerkesat_Anuluara`, `kerkesat_my_institut`, `Produktet_tona`, `user_profile`, `Furnitoret`, `Shiko_klient`, `Edito_klient`, `Shto_klient`, `Delete_klient`, `Shiko_pozite`, `Shto_pozite`, `Edito_pozite`, `Delete_pozite`, `Edito_qytet`, `Shiko_qytet`, `Delete_qytet`, `Shto_qytet`, GjithaPorositeKlientve, Porosite_Npritje, Porosite_Nprocesim, Porosite_Anuluara, Porosite_Perfunduara, Porosite_my_institut, Porosite_mine, parashtro_porosi) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)",
                [$statusi, $pozitat, $Dashboard, $Profili_im, $Harta, $kerkesat_mine, $parashtro_kerkese_servisi, $GjithaKerkesatKlienteve, $Kerkesat_Npritje, $Kerkesat_Nprocesim, $Kerkesat_Perfunduara, $GjithPerdoruesit, $Personeli, $Shto_perdorues, $Shiko_perdorues, $edito_perdorues, $fshij_perdorues, $cakto_role, $Klientet, $Klientet_Npritje, $Kerkesat_Anuluara, $kerkesat_my_institut, $Produktet_tona, $user_profile, $Furnitoret, $Shiko_klient, $Edito_klient, $Shto_klient, $Delete_klient, $Shiko_pozite, $Shto_pozite, $Edito_pozite, $Delete_pozite, $Edito_qytet, $Shiko_qytet, $Delete_qytet, $Shto_qytet, $GjithaPorositeKlientve, $Porosite_Npritje, $Porosite_Nprocesim, $Porosite_Anuluara, $Porosite_Perfunduara, $Porosite_my_institut, $Porosite_mine, $parashtro_porosi]
            );
            $res['success'] = true;
            $res['message'] = "Register success";
            return response($res, 200);
        } catch (\Illuminate\Database\QueryException $ex) {
            $res['success'] = false;
            $res['message'] = "Error";
            return response($res, 500);
        }
    }
    public function updatepozita(Request $request)
    {
        

        $Dashboard = $request->Dashboard;
        $Profili_im = $request->Profili_im;
        $Harta = $request->Harta;
        $kerkesat_mine = $request->kerkesat_mine;
        $parashtro_kerkese_servisi = $request->parashtro_kerkese_servisi;
        $GjithaKerkesatKlienteve = $request->GjithaKerkesatKlienteve;
        $Kerkesat_Npritje = $request->Kerkesat_Npritje;
        $Kerkesat_Nprocesim = $request->Kerkesat_Nprocesim;
        $Kerkesat_Perfunduara = $request->Kerkesat_Perfunduara;
        $GjithPerdoruesit = $request->GjithPerdoruesit;
        $Personeli = $request->Personeli;
        $Shto_perdorues = $request->Shto_perdorues;
        $Shiko_perdorues = $request->Shiko_perdorues;
        $edito_perdorues = $request->edito_perdorues;
        $fshij_perdorues = $request->fshij_perdorues;
        $cakto_role = $request->cakto_role;
        $Klientet = $request->Klientet;
        $Klientet_Npritje = $request->Klientet_Npritje;
        $Kerkesat_Anuluara = $request->Kerkesat_Anuluara;
        $kerkesat_my_institut = $request->kerkesat_my_institut;
        $Produktet_tona = $request->Produktet_tona;
        $user_profile = $request->user_profile;
        $Furnitoret = $request->Furnitoret;
        $Shiko_klient = $request->Shiko_klient;
        $Edito_klient = $request->Edito_klient;
        $Shto_klient = $request->Shto_klient;
        $Delete_klient = $request->Delete_klient;
        $Shiko_pozite = $request->Shiko_pozite;
        $Shto_pozite = $request->Shto_pozite;
        $Edito_pozite = $request->Edito_pozite;
        $Delete_pozite = $request->Delete_pozite;
        $Edito_qytet = $request->Edito_qytet;
        $Shiko_qytet = $request->Shiko_qytet;
        $Delete_qytet = $request->Delete_qytet;
        $Shto_qytet = $request->Shto_qytet;
        $statusi = $request->statusi;
        $GjithaPorositeKlientve = $request->GjithaPorositeKlientve;
        $Porosite_Npritje = $request->Porosite_Npritje;
        $Porosite_Nprocesim = $request->Porosite_Nprocesim;
        $Porosite_Anuluara = $request->Porosite_Anuluara;
        $Porosite_Perfunduara = $request->Porosite_Perfunduara;
        $Porosite_my_institut = $request->Porosite_my_institut;
        $Porosite_mine = $request->Porosite_mine;
        $parashtro_porosi = $request->parashtro_porosi;
        $id = $request->id;

        try {
            $_reg = DB::update(
                "UPDATE `pozitat` SET `Dashboard`=?,`Profili_im`=?,`kerkesat_mine`=?,`parashtro_kerkese_servisi`=?,`Harta`=?,`GjithaKerkesatKlienteve`=?,`Kerkesat_Npritje`=?,`Kerkesat_Nprocesim`=?,`Kerkesat_Perfunduara`=?,`GjithPerdoruesit`=?,`Personeli`=?,`Shto_perdorues`=?,`Shiko_perdorues`=?,`edito_perdorues`=?,`fshij_perdorues`=?,`cakto_role`=?,`Klientet`=?,`Klientet_Npritje`=?,`Kerkesat_Anuluara`=?,`kerkesat_my_institut`=?,`Produktet_tona`=?,`user_profile`=?,`Furnitoret`=?,`Shiko_klient`=?,`Edito_klient`=?,`Shto_klient`=?,`Delete_klient`=?,`Shiko_pozite`=?,`Shto_pozite`=?,`Edito_pozite`=?,`Delete_pozite`=?,`Shiko_qytet`=?,`Shto_qytet`=?,`Edito_qytet`=?,`Delete_qytet`=?,`GjithaPorositeKlientve`=?,`Porosite_Npritje`=?,`Porosite_Nprocesim`=?,`Porosite_Anuluara`=?,`Porosite_Perfunduara`=?,`Porosite_my_institut`=?,`Porosite_mine`=?,`parashtro_porosi`=? WHERE id=?",
                [ $Dashboard, $Profili_im,  $kerkesat_mine, $parashtro_kerkese_servisi,$Harta, $GjithaKerkesatKlienteve, $Kerkesat_Npritje, $Kerkesat_Nprocesim, $Kerkesat_Perfunduara, $GjithPerdoruesit, $Personeli, $Shto_perdorues, $Shiko_perdorues, $edito_perdorues, $fshij_perdorues, $cakto_role, $Klientet, $Klientet_Npritje, $Kerkesat_Anuluara, $kerkesat_my_institut, $Produktet_tona, $user_profile, $Furnitoret, $Shiko_klient, $Edito_klient, $Shto_klient, $Delete_klient, $Shiko_pozite, $Shto_pozite, $Edito_pozite, $Delete_pozite, $Shiko_qytet, $Shto_qytet, $Edito_qytet, $Delete_qytet, $GjithaPorositeKlientve, $Porosite_Npritje, $Porosite_Nprocesim, $Porosite_Anuluara, $Porosite_Perfunduara, $Porosite_my_institut, $Porosite_mine, $parashtro_porosi,$id]
            );
            $res['success'] = true;
            $res['message'] = "Register success";
            return response($res, 200);
        } catch (\Illuminate\Database\QueryException $ex) {
            $res['success'] = false;
            $res['message'] = "Error";
            return response($res, 500);
        }
    }
    public function getpozitaid(Request $request)
    {
        $id = $request->id;
        $products = DB::table('pozitat')->where('id',$id)->get();
        if (empty($products)) {
            $arr = array('code' => 404, 'data' => []);
            echo json_encode($arr);
        } else {
            $countallproducts = count($products);
            if ($countallproducts > 0) {
                return response()->json(array(
                    'code' => 200,
                    'data' => $products
                ), 200);
            }
        }
    }

    // done bY ME per Procedure 
    public function pozitat(Request $request)
    {
        $veprimi = $request->veprimi;
        $id_poz = $request->id_pozites;
        $emri_poz = $request->emri_pozites;

        try {
            $crudpoz = DB::select(
                ' CALL `Pozitat`(?, ?, ?)',
                [$veprimi, $id_poz, $emri_poz]
            );
            if ($veprimi == 'update') {
                $crudpoz = 'Perditsim eshte bere me sukses';
            }


            return response($crudpoz, 200);
        } catch (\Illuminate\Database\QueryException $ex) {
            $res['success'] = false;
            //  $ex->getMessage() per me shfaq qfar gabimi 
            $res['message'] = "Error";
            return response($res, 500);
        }
    }
    public function register(Request $request)
    {

        $perdoruesi = $request->perdoruesi;
        $fjalkalimi = $request->fjalkalimi;
        $pozita = $request->pozita;
        $emri = $request->emri;
        $mbiemri = $request->mbiemri;
        $datalindjes = $request->datalindjes;
        $gjinia = $request->gjinia;
        $adresa = $request->adresa;
        $institucioni = $request->institucioni;
        $nrkontakt = $request->nrkontakt;
        $statusi = $request->statusi;



        if (
            $request->perdoruesi == "" || is_null($request->perdoruesi) ||
            $request->fjalkalimi == "" || is_null($request->fjalkalimi) ||
            $request->pozita == "" || is_null($request->pozita)  ||
            $request->emri == "" || is_null($request->emri) ||
            $request->mbiemri == "" || is_null($request->mbiemri) ||
            $request->gjinia == "" || is_null($request->gjinia) ||
            $request->adresa == "" || is_null($request->adresa) ||
            $request->nrkontakt == "" || is_null($request->nrkontakt) ||
            $request->institucioni == "" || is_null($request->institucioni)
        ) {
            $res['success'] = false;
            $res['message'] = "Të plotësohen të gjitha fushat";
            return response($res, 422);
        }
        $ekziston = DB::table('perdoruesit')->where('perdoruesi', $perdoruesi)->first();
        if ($ekziston != null) {
            $res['success'] = false;
            $res['message'] = "Përdoruesi ekziston";
            return response($res, 491);
        }





        try {
            $_reg = DB::insert("INSERT INTO Perdoruesit(`perdoruesi`, `fjalekalimi`,`pozitat`,`emri`,`mbiemri`,`data_e_lindjes`,`gjinia`,`adresa`,`institucioni`,`nr_kontaktues`,`statusi`) 
     VALUES (?,SHA2(?,256),?,?,?,?,?,?,?,?,?)", [$perdoruesi, $fjalkalimi, $pozita, $emri, $mbiemri, $datalindjes, $gjinia, $adresa, $institucioni, $nrkontakt, $statusi]);
            $_reg2 = DB::select("SELECT id from Perdoruesit where perdoruesi='" . $perdoruesi . "'");
            $selid = json_decode(json_encode($_reg2), true);
            $this->useraddprofile($selid[0]['id'], $institucioni, $pozita);
            $res['success'] = true;
            $res['message'] = "Register success";
            return response($res, 200);
        } catch (\Illuminate\Database\QueryException $ex) {
            $res['success'] = false;
            $res['message'] = "Error";
            return response($res, 500);
        }
    }

    public function useraddprofile($uid, $labid, $roli)
    {
        $rolidb = DB::select("SELECT * from pozitat where id='" . $roli . "'");
        $labi = DB::select("SELECT AdminID from tbl_institucioni where id='" . $labid . "'");
        $rolidb = json_decode(json_encode($rolidb), true);
        $selid = json_decode(json_encode($labi), true);
        $labdb = DB::select("SELECT * from permmissions where perdoruesi_id='" . $selid[0]['AdminID'] . "'");
        $labdb = json_decode(json_encode($labdb), true);

        if ($rolidb[0]['Dashboard'] == 1 && $labdb[0]['Dashboard'] == 1) {
            $Dashboard = 1;
        } else {
            $Dashboard = 0;
        }
        if ($rolidb[0]['Profili_im'] == 1 && $labdb[0]['Profili_im'] == 1) {
            $Profili_im = 1;
        } else {
            $Profili_im = 0;
        }
        if ($rolidb[0]['kerkesat_mine'] == 1 && $labdb[0]['kerkesat_mine'] == 1) {
            $kerkesat_mine = 1;
        } else {
            $kerkesat_mine = 0;
        }
        if ($rolidb[0]['parashtro_kerkese_servisi'] == 1 && $labdb[0]['parashtro_kerkese_servisi'] == 1) {
            $parashtro_kerkese_servisi = 1;
        } else {
            $parashtro_kerkese_servisi = 0;
        }
        if ($rolidb[0]['Harta'] == 1 && $labdb[0]['Harta'] == 1) {
            $Harta = 1;
        } else {
            $Harta = 0;
        }
        if ($rolidb[0]['GjithaKerkesatKlienteve'] == 1 && $labdb[0]['GjithaKerkesatKlienteve'] == 1) {
            $GjithaKerkesatKlienteve = 1;
        } else {
            $GjithaKerkesatKlienteve = 0;
        }
        if ($rolidb[0]['Kerkesat_Npritje'] == 1 && $labdb[0]['Kerkesat_Npritje'] == 1) {
            $Kerkesat_Npritje = 1;
        } else {
            $Kerkesat_Npritje = 0;
        }
        if ($rolidb[0]['Kerkesat_Nprocesim'] == 1 && $labdb[0]['Kerkesat_Nprocesim'] == 1) {
            $Kerkesat_Nprocesim = 1;
        } else {
            $Kerkesat_Nprocesim = 0;
        }
        if ($rolidb[0]['Kerkesat_Perfunduara'] == 1 && $labdb[0]['Kerkesat_Perfunduara'] == 1) {
            $Kerkesat_Perfunduara = 1;
        } else {
            $Kerkesat_Perfunduara = 0;
        }
        if ($rolidb[0]['GjithPerdoruesit'] == 1 && $labdb[0]['GjithPerdoruesit'] == 1) {
            $GjithPerdoruesit = 1;
        } else {
            $GjithPerdoruesit = 0;
        }
        if ($rolidb[0]['Personeli'] == 1 && $labdb[0]['Personeli'] == 1) {
            $Personeli = 1;
        } else {
            $Personeli = 0;
        }
        if ($rolidb[0]['Shto_perdorues'] == 1 && $labdb[0]['Shto_perdorues'] == 1) {
            $Shto_perdorues = 1;
        } else {
            $Shto_perdorues = 0;
        }
        if ($rolidb[0]['Shiko_perdorues'] == 1 && $labdb[0]['Shiko_perdorues'] == 1) {
            $Shiko_perdorues = 1;
        } else {
            $Shiko_perdorues = 0;
        }
        if ($rolidb[0]['edito_perdorues'] == 1 && $labdb[0]['edito_perdorues'] == 1) {
            $edito_perdorues = 1;
        } else {
            $edito_perdorues = 0;
        }
        if ($rolidb[0]['fshij_perdorues'] == 1 && $labdb[0]['fshij_perdorues'] == 1) {
            $fshij_perdorues = 1;
        } else {
            $fshij_perdorues = 0;
        }
        if ($rolidb[0]['cakto_role'] == 1 && $labdb[0]['cakto_role'] == 1) {
            $cakto_role = 1;
        } else {
            $cakto_role = 0;
        }
        if ($rolidb[0]['Klientet'] == 1 && $labdb[0]['Klientet'] == 1) {
            $Klientet = 1;
        } else {
            $Klientet = 0;
        }
        if ($rolidb[0]['Klientet_Npritje'] == 1 && $labdb[0]['Klientet_Npritje'] == 1) {
            $Klientet_Npritje = 1;
        } else {
            $Klientet_Npritje = 0;
        }
        if ($rolidb[0]['Kerkesat_Anuluara'] == 1 && $labdb[0]['Kerkesat_Anuluara'] == 1) {
            $Kerkesat_Anuluara = 1;
        } else {
            $Kerkesat_Anuluara = 0;
        }
        if ($rolidb[0]['kerkesat_my_institut'] == 1 && $labdb[0]['kerkesat_my_institut'] == 1) {
            $kerkesat_my_institut = 1;
        } else {
            $kerkesat_my_institut = 0;
        }
        if ($rolidb[0]['Produktet_tona'] == 1 && $labdb[0]['Produktet_tona'] == 1) {
            $Produktet_tona = 1;
        } else {
            $Produktet_tona = 0;
        }
        if ($rolidb[0]['user_profile'] == 1 && $labdb[0]['user_profile'] == 1) {
            $user_profile = 1;
        } else {
            $user_profile = 0;
        }
        if ($rolidb[0]['Furnitoret'] == 1 && $labdb[0]['Furnitoret'] == 1) {
            $Furnitoret = 1;
        } else {
            $Furnitoret = 0;
        }
        if ($rolidb[0]['Shiko_klient'] == 1 && $labdb[0]['Shiko_klient'] == 1) {
            $Shiko_klient = 1;
        } else {
            $Shiko_klient = 0;
        }
        if ($rolidb[0]['Edito_klient'] == 1 && $labdb[0]['Edito_klient'] == 1) {
            $Edito_klient = 1;
        } else {
            $Edito_klient = 0;
        }
        if ($rolidb[0]['Shto_klient'] == 1 && $labdb[0]['Shto_klient'] == 1) {
            $Shto_klient = 1;
        } else {
            $Shto_klient = 0;
        }
        if ($rolidb[0]['Delete_klient'] == 1 && $labdb[0]['Delete_klient'] == 1) {
            $Delete_klient = 1;
        } else {
            $Delete_klient = 0;
        }
        if ($rolidb[0]['Shiko_pozite'] == 1 && $labdb[0]['Shiko_pozite'] == 1) {
            $Shiko_pozite = 1;
        } else {
            $Shiko_pozite = 0;
        }
        if ($rolidb[0]['Shto_pozite'] == 1 && $labdb[0]['Shto_pozite'] == 1) {
            $Shto_pozite = 1;
        } else {
            $Shto_pozite = 0;
        }
        if ($rolidb[0]['Edito_pozite'] == 1 && $labdb[0]['Edito_pozite'] == 1) {
            $Edito_pozite = 1;
        } else {
            $Edito_pozite = 0;
        }
        if ($rolidb[0]['Delete_pozite'] == 1 && $labdb[0]['Delete_pozite'] == 1) {
            $Delete_pozite = 1;
        } else {
            $Delete_pozite = 0;
        }
        if ($rolidb[0]['Shiko_qytet'] == 1 && $labdb[0]['Shiko_qytet'] == 1) {
            $Shiko_qytet = 1;
        } else {
            $Shiko_qytet = 0;
        }
        if ($rolidb[0]['Shto_qytet'] == 1 && $labdb[0]['Shto_qytet'] == 1) {
            $Shto_qytet = 1;
        } else {
            $Shto_qytet = 0;
        }
        if ($rolidb[0]['Edito_qytet'] == 1 && $labdb[0]['Edito_qytet'] == 1) {
            $Edito_qytet = 1;
        } else {
            $Edito_qytet = 0;
        }
        if ($rolidb[0]['Delete_qytet'] == 1 && $labdb[0]['Delete_qytet'] == 1) {
            $Delete_qytet = 1;
        } else {
            $Delete_qytet = 0;
        }
        if ($rolidb[0]['GjithaPorositeKlientve'] == 1 && $labdb[0]['GjithaPorositeKlientve'] == 1) {
            $GjithaPorositeKlientve = 1;
        } else {
            $GjithaPorositeKlientve = 0;
        }
        if ($rolidb[0]['Porosite_Npritje'] == 1 && $labdb[0]['Porosite_Npritje'] == 1) {
            $Porosite_Npritje = 1;
        } else {
            $Porosite_Npritje = 0;
        }
        if ($rolidb[0]['Porosite_Nprocesim'] == 1 && $labdb[0]['Porosite_Nprocesim'] == 1) {
            $Porosite_Nprocesim = 1;
        } else {
            $Porosite_Nprocesim = 0;
        }
        if ($rolidb[0]['Porosite_Anuluara'] == 1 && $labdb[0]['Porosite_Anuluara'] == 1) {
            $Porosite_Anuluara = 1;
        } else {
            $Porosite_Anuluara = 0;
        }
        if ($rolidb[0]['Porosite_Perfunduara'] == 1 && $labdb[0]['Porosite_Perfunduara'] == 1) {
            $Porosite_Perfunduara = 1;
        } else {
            $Porosite_Perfunduara = 0;
        }
        if ($rolidb[0]['Porosite_my_institut'] == 1 && $labdb[0]['Porosite_my_institut'] == 1) {
            $Porosite_my_institut = 1;
        } else {
            $Porosite_my_institut = 0;
        }
        if ($rolidb[0]['Porosite_mine'] == 1 && $labdb[0]['Porosite_mine'] == 1) {
            $Porosite_mine = 1;
        } else {
            $Porosite_mine = 0;
        }
        if ($rolidb[0]['parashtro_porosi'] == 1 && $labdb[0]['parashtro_porosi'] == 1) {
            $parashtro_porosi = 1;
        } else {
            $parashtro_porosi = 0;
        }
        $_reg = DB::insert(
            " INSERT INTO `permmissions`( `perdoruesi_id`, `Dashboard`, `Profili_im`, `kerkesat_mine`, `parashtro_kerkese_servisi`, `Harta`, `GjithaKerkesatKlienteve`, `Kerkesat_Npritje`, `Kerkesat_Nprocesim`, `Kerkesat_Perfunduara`, `GjithPerdoruesit`, `Personeli`, `Shto_perdorues`, `Shiko_perdorues`, `edito_perdorues`, `fshij_perdorues`, `cakto_role`, `Klientet`, `Klientet_Npritje`, `Kerkesat_Anuluara`, `kerkesat_my_institut`, `Produktet_tona`, `user_profile`, `Furnitoret`, `Shiko_klient`, `Edito_klient`, `Shto_klient`, `Delete_klient`, `Shiko_pozite`, `Shto_pozite`, `Edito_pozite`, `Delete_pozite`, `Shiko_qytet`, `Shto_qytet`, `Edito_qytet`, `Delete_qytet`, GjithaPorositeKlientve, Porosite_Npritje, Porosite_Nprocesim, Porosite_Anuluara, Porosite_Perfunduara, Porosite_my_institut, Porosite_mine, parashtro_porosi) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)",
            [$uid, $Dashboard, $Profili_im, $kerkesat_mine, $parashtro_kerkese_servisi, $Harta, $GjithaKerkesatKlienteve, $Kerkesat_Npritje, $Kerkesat_Nprocesim, $Kerkesat_Perfunduara, $GjithPerdoruesit, $Personeli, $Shto_perdorues, $Shiko_perdorues, $edito_perdorues, $fshij_perdorues, $cakto_role, $Klientet, $Klientet_Npritje, $Kerkesat_Anuluara, $kerkesat_my_institut, $Produktet_tona, $user_profile, $Furnitoret, $Shiko_klient, $Edito_klient, $Shto_klient, $Delete_klient, $Shiko_pozite, $Shto_pozite, $Edito_pozite, $Delete_pozite, $Shiko_qytet, $Shto_qytet, $Edito_qytet, $Delete_qytet, $GjithaPorositeKlientve, $Porosite_Npritje, $Porosite_Nprocesim, $Porosite_Anuluara, $Porosite_Perfunduara, $Porosite_my_institut, $Porosite_mine, $parashtro_porosi]
        );
    }
    function getallinstitut(){
        
        $products = DB::table('tbl_institucioni')->get();
        if (empty($products)) {
            $arr = array('code' => 404, 'data' => []);
            echo json_encode($arr);
        } else {
            $countallproducts = count($products);
            if ($countallproducts > 0) {
                return response()->json(array(
                    'code' => 200,
                    'data' => $products
                ), 200);
            }
        }
    }
}
