<?php

namespace App\Http\Middleware;

use Closure;
use Firebase\JWT\ExpiredException;
use Exception;
use Firebase\JWT\JWT;
use Firebase\JWT\Key;
use Illuminate\Contracts\Auth\Factory as Auth;
use Illuminate\Support\Facades\DB;
class Authenticate
{
    /**
     * The authentication guard factory instance.
     *
     * @var \Illuminate\Contracts\Auth\Factory
     */
    protected $auth;

    /**
     * Create a new middleware instance.
     *
     * @param  \Illuminate\Contracts\Auth\Factory  $auth
     * @return void
     */
    public function __construct(Auth $auth)
    {
        $this->auth = $auth;
    }

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|null  $guard
     * @return mixed
     */
    public function handle($request, Closure $next, $guard = null)
    {
        $publicKey = <<<EOD
-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA3iT//4mWVtxHUgxjuPOt
1NFBxJVeHWZy4Zjav903DtD9KKyNtRfsBtEBq+JQsG49EGzNscdvzGdFocJIPImx
SZX/2lR74UeajD/CLPqJlAZHW289xAK25niIPpuOV1b1AGuGio0rau+Dkgm2A3Ku
RpFsMLK5WUGEZBPUm6g7Fv+BC5vbLTeBjU34ShtrCgPaBMmSmyaUbGfLgAGt/qR8
UGR9NjhTo0RwYTQtfx63GSb0gYjtE1V3/H/cO0DK8JcDd2nrk69970twPfb7GFLg
gXyK8IMNX4JhZ1L3Z76Q2ZvW5U54ZsMUUa2qlDBHH6u4wEqG7asGjsXjfJzqva6r
HQIDAQAB
-----END PUBLIC KEY-----
EOD;
        if ($this->auth->guard($guard)->guest()) {
          
            $token =  $request->header('api_token');
            if (!$token) {
                $res['success'] = false;
                $res['message'] =  'Unauthorized' ;
                return response($res, 401);
            }
 
            try {
                $credentials = JWT::decode($token,  new Key($publicKey, 'RS256'));
                
    

                $ttc = $credentials->token;
                $check_token = DB::select("SELECT * FROM perdoruesit t WHERE t.api_token = ?", [$ttc]);
                if (count($check_token) == 0) {
                    $res['success'] = false;
                    $res['message'] = 'UNAUTHORIZED';
                    $res['code'] = 404;
                    return response($res, 401);
                }
            } catch (ExpiredException $e) {
                $res['success'] = false;
                $res['message'] = $e->getmessage();
                return response($res, 401);
            } 
            catch (Exception $e) {
                $res['success'] = false;
                $res['message'] =  $e->getmessage();
                return response($res, 401);
            }
           
 
        } else {
            $res['success'] = false;
            $res['message'] = 'UNAUTHORIZED';
            return response($res, 401);
        }
 
        return $next($request);
    }
}

