<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use League\Flysystem;

class ServicesnbrandsController extends Controller
{
  /**
   * Create a new controller instance.
   *
   * @return void
   */
  public function __construct()
  {
    $this->middleware('auth');
  }


  public function uploadimg(Request $request)
  {

    // $file = $request->file('upload_file');
    // $uniqueFileName = uniqid() . $file->getClientOriginalName() . '.' . $file->getClientOriginalExtension();
    // $imageName = time().'.'.  $request->file('upload_file')->getClientOriginalName();

    if ($request->hasFile('foto')) {
      $logoImage = $request->file('foto');
      $name = $logoImage->getClientOriginalName();
      $request->file('foto')->move('images', $name);
      $res['success'] = true;
      $res['message'] = $name;
      return response($res, 200);
    }
  }
  // done by me per Procedure te Pajisjes  
  public function updatepajisja(Request $request)
  {
   
    $id_pjs = $request->id;
    $emri_pjs = $request->emripajisjes;
    $sts = $request->sts;

    try {
      $crudpajisja = DB::table('pajisja')->where('id',$id_pjs)->update(['emri_pajisjes'=>$emri_pjs,'statusi'=>$sts]);
      return response($crudpajisja, 200);
    } catch (\Illuminate\Database\QueryException $ex) {
      $res['success'] = false;
      //  $ex->getMessage() per me shfaq qfar gabimi 
      $res['message'] =  "error";
      return response($res, 500);
    }
  }

  // done by me per Procedure te Pajisjes  
  public function pajisja(Request $request)
  {
    //params tparat jane me ato qysh i kemi deklaru ne procedure
    // tdytat mujn me kon tmarrne nga inputi qe jane te deklarume ne ajax
    $veprimi = $request->veprimi;
    $id_pjs = $request->id;
    $emri_pjs = $request->emripajisjes;
    $frm_paisje = $request->frm_paisje;
    $userid = $request->userid;
    $sts = $request->sts;
    $img = $request->img;



    if ($veprimi == 'insert') {
      $ekziston = DB::table('pajisja')->where('emri_pajisjes', $emri_pjs)->first();
      if ($ekziston != null) {
        $res['success'] = false;
        $res['message'] = "Pajisja ekziston";
        return response($res, 491);
      }
    }

    try {
      $crudpajisja = DB::select(
        'CALL `Pajisjet`(?, ?, ?,?,?,?,?)',
        [$veprimi, $id_pjs, $emri_pjs, $frm_paisje, $userid, $sts, $img]
      );
      // if($veprimi=='delete'){
      //   $crudpajisja='Sukses';
      // }
      // if($veprimi=='delete'){
      //   $crudpajisja='Fshirja eshte bere me sukses';
      // }
      // if($veprimi=='update'){
      //   $crudpajisja='Perditsim eshte bere me sukses';
      // }


      return response($crudpajisja, 200);
    } catch (\Illuminate\Database\QueryException $ex) {
      $res['success'] = false;
      //  $ex->getMessage() per me shfaq qfar gabimi 
      $res['message'] =  "error";
      return response($res, 500);
    }
  }
  public function paisjains(Request $request)
  {

    $emri_pjs = $request->emripajisjes;
    $frm_paisje = $request->frm_paisje;
    $userid = $request->userid;
    $sts = $request->sts;
    $img = $request->img;




    $ekziston = DB::table('pajisja')->where('emri_pajisjes', $emri_pjs)->first();
    if ($ekziston != null) {
      $res['success'] = false;
      $res['message'] = "Pajisja ekziston";
      return response($res, 491);
    }


    try {
      $crudpajisja = DB::insert(
        'INSERT INTO pajisja(emri_pajisjes,firma_prodhuese,nga_perdoruesi_id,statusi,image) VALUES (?,?,?,?,?);',
        [$emri_pjs, $frm_paisje, $userid, $sts, $img]
      );



      return response($crudpajisja, 200);
    } catch (\Illuminate\Database\QueryException $ex) {
      $res['success'] = false;
      $res['message'] =  "error";
      return response($res, 500);
    }
  }


  public function shfaqpajsije($id)
  {
    $getmydevice = DB::select('SELECT p.id, p.emri_pajisjes, p.firma_prodhuese, p.statusi, b.id, b.emri_prodhuesit, s.vlera, s.emri_statusit
    FROM pajisja p
    LEFT JOIN firma_prodhuese_pajisjeve b  ON p.firma_prodhuese = b.id
    LEFT JOIN statusi s  ON p.statusi = s.vlera
    WHERE p.statusi =1 AND b.id =' . $id);
    if (empty($getmydevice)) {
      $arr = array(300);
      echo json_encode($arr);
    } else {
      $countgetmydevice = count($getmydevice);
      if ($countgetmydevice > 0) {
        return response()->json(

          $getmydevice,

        );
      }
    }
  }
  public function updateservice(Request $request)
  {

    $id_ser = $request->id;
    $emri_ser = $request->emripajisjes;



    try {
      $crudpajisja = DB::table('services')->where('id', $id_ser)->update([
        'service_name' => $emri_ser
      ]);

      return response('Sukses', 200);
    } catch (\Illuminate\Database\QueryException $ex) {
      $res['success'] = false;
      //  "error" per me shfaq qfar gabimi 
      $res['message'] =  "error";
      return response($res, 500);
    }
  }
  public function service(Request $request)
  {
    //params tparat jane me ato qysh i kemi deklaru ne procedure
    // tdytat mujn me kon tmarrne nga inputi qe jane te deklarume ne ajax
    $veprimi = $request->veprimi;
    $id_ser = $request->id;
    $emri_ser = $request->emripajisjes;
    $userid = $request->userid;


    if ($veprimi == 'insert') {
      $ekziston = DB::table('services')->where('service_name', $emri_ser)->first();
      if ($ekziston != null) {
        $res['success'] = false;
        $res['message'] = "Servisi ekziston";
        return response($res, 491);
      }
    }

    try {
      $crudpajisja = DB::select(
        'CALL `Service`(?, ?,?,?)',
        [$veprimi, $id_ser, $emri_ser, $userid]
      );
      // if($veprimi=='delete'){
      //   $crudpajisja='Sukses';
      // }
      // if($veprimi=='delete'){
      //   $crudpajisja='Fshirja eshte bere me sukses';
      // }
      // if($veprimi=='update'){
      //   $crudpajisja='Perditsim eshte bere me sukses';
      // }


      return response($crudpajisja, 200);
    } catch (\Illuminate\Database\QueryException $ex) {
      $res['success'] = false;
      //  "error" per me shfaq qfar gabimi 
      $res['message'] =  "error";
      return response($res, 500);
    }
  }
  public function serviceins(Request $request)
  {

    $emri_ser = $request->emripajisjes;
    $userid = $request->userid;


    $ekziston = DB::table('services')->where('service_name', $emri_ser)->first();
    if ($ekziston != null) {
      $res['success'] = false;
      $res['message'] = "Servisi ekziston";
      return response($res, 491);
    }


    try {
      $crudpajisja = DB::insert(
        'INSERT INTO services(service_name,nga_perdoruesi_id) VALUES(?,?)',
        [$emri_ser, $userid]
      );


      return response($crudpajisja, 200);
    } catch (\Illuminate\Database\QueryException $ex) {
      $res['success'] = false;
      //  "error" per me shfaq qfar gabimi 
      $res['message'] =  "error";
      return response($res, 500);
    }
  }


  public function updateprioriteti(Request $request)
  {
    $id_ser = $request->id;
    $emripr = $request->emripr;
    $pershkrim = $request->pershkrimi;


    try {
      
        $crudpajisja = DB::table('prioritetet')->where('id',$id_ser)->update(['emri'=>$emripr,'pershkrimi'=>$pershkrim]);
  
      return response('Sukses', 200);
    } catch (\Illuminate\Database\QueryException $ex) {
      $res['success'] = false;
      //  "error" per me shfaq qfar gabimi 
      $res['message'] =  "error";
      return response($res, 500);
    }
  }
  public function prioritete(Request $request)
  {
    //params tparat jane me ato qysh i kemi deklaru ne procedure
    // tdytat mujn me kon tmarrne nga inputi qe jane te deklarume ne ajax
    $veprimi = $request->veprimi;
    $id_ser = $request->id;
    $emripr = $request->emripr;
    $pershkrim = $request->pershkrimi;
    $userid = $request->userid;

    if ($veprimi == 'insert') {
      $ekziston = DB::table('prioritetet')->where('emri', $emripr)->first();
      if ($ekziston != null) {
        $res['success'] = false;
        $res['message'] = "Servisi ekziston";
        return response($res, 491);
      }
    }
    // $veprimi= intval($veprimi);
    // $id_ser= intval($id_ser);
    // $emripr= intval($emripr);
    // $pershkrim= intval($pershkrim);
    // $userid= intval($userid);



    try {
      if ($veprimi == 'insert') {
        $crudpajisja = DB::insert(
          'CALL `prioritete`(?, ?,?,?,?)',
          [$veprimi, $id_ser, $emripr, $pershkrim, $userid]
        );
      } else {
        $crudpajisja = DB::select(
          'CALL `prioritete`(?, ?,?,?,?)',
          [$veprimi, $id_ser, $emripr, $pershkrim, $userid]
        );
      }
      // if($veprimi=='delete'){
      //   $crudpajisja='Sukses';
      // }
      // if($veprimi=='delete'){
      //   $crudpajisja='Fshirja eshte bere me sukses';
      // }
      // if($veprimi=='update'){
      //   $crudpajisja='Perditsim eshte bere me sukses';
      // }


      return response($crudpajisja, 200);
    } catch (\Illuminate\Database\QueryException $ex) {
      $res['success'] = false;
      //  "error" per me shfaq qfar gabimi 
      $res['message'] =  "error";
      return response($res, 500);
    }
  }


  public function updatebrend(Request $request)
  {


    $id_brand = $request->id;
    $emri_brand = $request->emri_firmes;
    $pershkrim_brand = $request->pershkrim;
    $logoimg = $request->logoimg;
    $userid = $request->userid;



    try {
      $crudfirma = DB::table('firma_prodhuese_pajisjeve')->where('id', $id_brand)->update([
        'emri_prodhuesit' => $emri_brand,
        'pershkrimi' => $pershkrim_brand,
        'logo_img' => $logoimg,
        'nga_perdoruesi_id' => $userid,
      ]);

      return response('Sukses', 200);
    } catch (\Illuminate\Database\QueryException $ex) {
      $res['success'] = false;
      //  "error" per me shfaq qfar gabimi 
      $res['message'] =  "error";
      return response($res, 500);
    }
  }
  // done by me per Procedure te Pajisjes  
  public function firma(Request $request)
  {
    //params tparat jane me ato qysh i kemi deklaru ne procedure
    // tdytat mujn me kon tmarrne nga inputi qe jane te deklarume ne ajax
    $veprimi = $request->veprimi;
    $id_brand = $request->id;
    $emri_brand = $request->emri_firmes;
    $pershkrim_brand = $request->pershkrim;
    $logoimg = $request->logoimg;
    $userid = $request->userid;
    $ord = $request->ord;

    if ($veprimi == 'insert') {
      $ekziston = DB::table('firma_prodhuese_pajisjeve')->where('emri_prodhuesit', $emri_brand)->first();
      if ($ekziston != null) {
        $res['success'] = false;
        $res['message'] = "Firma ekziston";
        return response($res, 491);
      }
    }

    try {
      $crudfirma = DB::select(
        'CALL `Firma`(?, ?, ?, ?,?,?,?)',
        [$veprimi, $id_brand, $emri_brand, $pershkrim_brand, $logoimg, $userid, $ord]
      );
      if ($veprimi == 'delete') {
        $crudfirma = 'Sukses';
      }
      if ($veprimi == 'delete') {
        $crudfirma = 'Fshirja eshte bere me sukses';
      }
      if ($veprimi == 'update') {
        $crudfirma = 'Perditsim eshte bere me sukses';
      }


      return response($crudfirma, 200);
    } catch (\Illuminate\Database\QueryException $ex) {
      $res['success'] = false;
      //  "error" per me shfaq qfar gabimi 
      $res['message'] =  "error";
      return response($res, 500);
    }
  }
  public function firmains(Request $request)
  {

    $emri_brand = $request->emri_firmes;
    $pershkrim_brand = $request->pershkrim;
    $logoimg = $request->logoimg;
    $userid = $request->userid;
    $ord = $request->ord;


    $ekziston = DB::table('firma_prodhuese_pajisjeve')->where('emri_prodhuesit', $emri_brand)->first();
    if ($ekziston != null) {
      $res['success'] = false;
      $res['message'] = "Firma ekziston";
      return response($res, 491);
    }


    try {
      $crudfirma = DB::insert(
        'INSERT INTO `firma_prodhuese_pajisjeve`( `emri_prodhuesit`, `pershkrimi`, `logo_img`, `nga_perdoruesi_id`,OrderBy) VALUES (?,?,?,?,?)',
        [$emri_brand, $pershkrim_brand, $logoimg, $userid, $ord]
      );



      return response($crudfirma, 200);
    } catch (\Illuminate\Database\QueryException $ex) {
      $res['success'] = false;
      //  "error" per me shfaq qfar gabimi 
      $res['message'] =  "error";
      return response($res, 500);
    }
  }
  public function tbl_serv_brand_institution()
  {
    $getall = DB::select('SELECT pp.id AS IDP, pp.pajisja_id, pp.instituti_id, pp.numri_serik, pp.data_shitjes, p.id, p.emri_pajisjes, p.firma_prodhuese, ins.id, ins.emri_institutit, ins.numri_biznesit, ins.qyteti, q.id, q.emri_qytetit, fpp.id, fpp.emri_prodhuesit
      FROM perkatesia_pajisjes pp
      INNER JOIN pajisja p ON pp.pajisja_id = p.id
      INNER JOIN tbl_institucioni ins ON pp.instituti_id = ins.id
      INNER JOIN qyteti q ON ins.qyteti = q.id
      INNER JOIN firma_prodhuese_pajisjeve fpp ON p.firma_prodhuese = fpp.id');
    if (empty($getall)) {
      $arr = array(300);
      echo json_encode($arr);
    } else {
      $countgetall = count($getall);
      if ($countgetall > 0) {
        return response()->json(

          $getall,

        );
      }
    }
  }

  public function paisjeforfirma($id)
  {
    $getmydevice = DB::select('SELECT p.* FROM `pajisja` p
        LEFT JOIN firma_prodhuese_pajisjeve f
        ON p.firma_prodhuese=f.id 
        WHERE f.id=' . $id);
    if (empty($getmydevice)) {
      return response()->json(

        []

      );
    } else {
      $countgetmydevice = count($getmydevice);
      if ($countgetmydevice > 0) {
        return response()->json(

          $getmydevice,

        );
      }
    }
  }
  // perkatesia START START START START START START START START START START START START START START START 
  public function perkatsipaisja($id)
  {
    $getmydevice = DB::select('SELECT pp.id, pp.pajisja_id, pp.brand_id, pp.instituti_id, pp.numri_serik, pp.versioni_programit, pp.data_shitjes,
        p.id as paisjeid, p.emri_pajisjes, p.firma_prodhuese, p.statusi,
        b.id, b.emri_prodhuesit, b.emri_prodhuesit, b.statusi
        
        FROM perkatesia_pajisjes pp
        LEFT JOIN pajisja p ON pp.pajisja_id= p.id
        LEFT JOIN firma_prodhuese_pajisjeve b ON pp.brand_id= b.id
        
        WHERE p.statusi = 1 AND b.statusi = 1 AND instituti_id=' . $id);
    if (empty($getmydevice)) {
      $arr = array(300);
      echo json_encode($arr);
    } else {
      $countgetmydevice = count($getmydevice);
      if ($countgetmydevice > 0) {
        return response()->json(

          $getmydevice,

        );
      }
    }
  }
  public function get_pp($id)
  {
    $getpp = DB::select('SELECT pp.id, pp.pajisja_id, pp.brand_id, pp.instituti_id, pp.numri_serik, pp.versioni_programit, pp.data_shitjes,
    p.id as paisjeid, p.emri_pajisjes, p.firma_prodhuese, p.statusi,
    b.id, b.emri_prodhuesit, b.statusi, ti.emri_institutit
    FROM perkatesia_pajisjes pp
    LEFT JOIN pajisja p ON pp.pajisja_id= p.id
    LEFT JOIN firma_prodhuese_pajisjeve b ON pp.brand_id= b.id
    LEFT JOIN tbl_institucioni ti ON pp.instituti_id= ti.id
    WHERE pp.id =' . $id);
    if (empty($getpp)) {
      $arr = array(300);
      echo json_encode($arr);
    } else {
      $countgetpp = count($getpp);
      if ($countgetpp > 0) {
        return response()->json(

          $getpp,

        );
      }
    }
  }

  public function update_pp(Request $request, $id)
  {
    $pajisja_id = $request->pajisja_id;
    $brand_id = $request->brand_id;
    $instituti_id = $request->instituti_id;
    $numri_serik = $request->numri_serik;
    $data_shitjes = $request->data_shitjes;
    $nga_perdoruesi_id = $request->userid;
    $versioni_programit = $request->versioni_programit;

    try {
      $_reg = DB::update("UPDATE `perkatesia_pajisjes` SET `pajisja_id`='$pajisja_id',`brand_id`='$brand_id',`instituti_id`='$instituti_id',`numri_serik`='$numri_serik',`data_shitjes`='$data_shitjes',`nga_perdoruesi_id`='$nga_perdoruesi_id',`versioni_programit`='$versioni_programit' WHERE id =" . $id);

      $res['success'] = true;
      $res['message'] = "Përkatësia / të dhënat e pajisjes u ndryshuan me sukses! ";
      return response($res, 200);
    } catch (\Illuminate\Database\QueryException $ex) {
      $res['success'] = false;
      $res['message'] = "error";
      return response($res, 500);
    }
  }
  //  perktesia END END END END END END END END END END END END END END END END END END END END END END END END END END END END END END END END END END END 
  public function servpaisje($id)
  {
    $getmydevice = DB::select('SELECT s.services_id,ser.service_name FROM `servisimet_per_firma` s 
        left JOIN services ser 
        on ser.id=s.services_id WHERE
        pajisjet_id=' . $id);
    if (empty($getmydevice)) {
      $arr = array(300);
      echo json_encode($arr);
    } else {
      $countgetmydevice = count($getmydevice);
      if ($countgetmydevice > 0) {
        return response()->json(

          $getmydevice,

        );
      }
    }
  }
  public function getkerkesaid()
  {
    $getmydevice = DB::select('SELECT MAX(visitid) as id FROM kerkesat');
    if (empty($getmydevice)) {
      $arr = array(300);
      echo json_encode($arr);
    } else {
      $countgetmydevice = count($getmydevice);
      if ($countgetmydevice > 0) {
        return response()->json(

          $getmydevice,

        );
      }
    }
  }
  public function shtoservisefirma(Request $request)
  {
    //params tparat jane me ato qysh i kemi deklaru ne procedure
    // tdytat mujn me kon tmarrne nga inputi qe jane te deklarume ne ajax
    $firma_prodhuese_id = $request->firma_prodhuese_id;
    $pajisjet_id = $request->pajisjet_id;
    $services_id = $request->services_id;

    $userid = $request->userid;


    try {
      $crudpajisja = DB::insert(
        'INSERT INTO servisimet_per_firma( `firma_prodhuese_id`, `pajisjet_id`, `services_id`, `nga_perdoruesi_id`) VALUES (?, ?, ?,?)',
        [$firma_prodhuese_id, $pajisjet_id, $services_id, $userid]
      );



      return response($crudpajisja, 200);
    } catch (\Illuminate\Database\QueryException $ex) {
      $res['success'] = false;
      //  "error" per me shfaq qfar gabimi 
      $res['message'] =  "error";
      return response($res, 500);
    }
  }
  public function caktopaisjes(Request $request)
  {
    //params tparat jane me ato qysh i kemi deklaru ne procedure
    // tdytat mujn me kon tmarrne nga inputi qe jane te deklarume ne ajax
    $pajisja_id = $request->pajisja_id;
    $brand_id = $request->brand_id;
    $instituti_id = $request->instituti_id;

    $numri_serik = $request->numri_serik;
    $data_shitjes = $request->data_shitjes;
    $nga_perdoruesi_id = $request->userid;
    $versioni_programit = $request->versioni_programit;


    try {
      $crudpajisja = DB::insert(
        'INSERT INTO perkatesia_pajisjes( `pajisja_id`, `brand_id`, `instituti_id`, `numri_serik`,data_shitjes,nga_perdoruesi_id,versioni_programit) VALUES (?,?,?, ?,?,?,?)',
        [$pajisja_id, $brand_id, $instituti_id, $numri_serik, $data_shitjes, $nga_perdoruesi_id, $versioni_programit]
      );



      return response($crudpajisja, 200);
    } catch (\Illuminate\Database\QueryException $ex) {
      $res['success'] = false;
      //  "error" per me shfaq qfar gabimi 
      $res['message'] =  "error";
      return response($res, 500);
    }
  }
  public function shtokerkes(Request $request)
  {
    //params tparat jane me ato qysh i kemi deklaru ne procedure
    // tdytat mujn me kon tmarrne nga inputi qe jane te deklarume ne ajax
    $brand = $request->brand;
    $paisje = $request->paisje;
    $service = $request->service;

    $prioriteti = $request->prioriteti;
    $pershkrimi = $request->pershkrimi;
    $visitid = $request->visitid;
    $emriperdorues = $request->emriperdorues;
    $emriinstitutit = $request->emriinstitutit;
    $datatash = Carbon::now();
    if (
      $brand == null || $paisje == null ||
      $service == null || $prioriteti == null
    ) {
      $res['success'] = false;
      //  "error" per me shfaq qfar gabimi 
      $res['message'] = 'Plotsoni te Gjitha fushat';
      return response($res, 400);
    }
    try {
      $crudpajisja = DB::insert(
        'INSERT INTO `kerkesat`( `brand`, `paisje`, `service`, `prioriteti`, `pershkrimi`, `visitid`, `perderues_id`, `institucioni_id`) VALUES (?,?,?,?,?,?,?,?)',
        [$brand, $paisje, $service, $prioriteti, $pershkrimi, $visitid, $emriperdorues, $emriinstitutit]
      );
      // $crudhistoriakerkeses = DB::insert(
      //   'INSERT INTO `kerkesat_historia`(`Komenti`, `VisitID`, `user_id`, `statusi`) VALUES (?,?,?,?)',
      //   [ $pershkrimi, $visitid, $emriperdorues,0]
      // );
      return response($crudpajisja, 200);
    } catch (\Illuminate\Database\QueryException $ex) {
      $res['success'] = false;
      //  "error" per me shfaq qfar gabimi 
      $res['message'] =  'Error';
      return response($res, 500);
    }
  }
  public function tbl_stock(Request $request)
  {
    $id = $request->input('id', null);
    if ($id != null) {
      $getall = DB::select('SELECT sp.*,  p.emri_pajisjes,fpp.emri_prodhuesit
    FROM stockupaisje sp
    LEFT JOIN pajisja p ON sp.pasjisja_id = p.id
    LEFT JOIN firma_prodhuese_pajisjeve fpp ON sp.brend_id = fpp.id WHERE sp.Id=' . $id);
    } else {
      $getall = DB::select('SELECT sp.*, p.id, p.emri_pajisjes, fpp.id, fpp.emri_prodhuesit
    FROM stockupaisje sp
    INNER JOIN pajisja p ON sp.pasjisja_id = p.id
    INNER JOIN firma_prodhuese_pajisjeve fpp ON sp.brend_id = fpp.id');
    }
    if (empty($getall)) {
      $arr = array(300);
      echo json_encode($arr);
    } else {
      $countgetall = count($getall);
      if ($countgetall > 0) {
        return response()->json(

          $getall,

        );
      }
    }
  }
}
