<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

use function PHPUnit\Framework\isNull;

class PorosiController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function brendet()
    {
        $getmydevice = DB::select('SELECT s.brend_id,f.emri_prodhuesit FROM `stockupaisje` s LEFT JOIN firma_prodhuese_pajisjeve f ON s.brend_id=f.id GROUP BY `brend_id`
      ');
        if (empty($getmydevice)) {
            $arr = array(300);
            echo json_encode($arr);
        } else {
            $countgetmydevice = count($getmydevice);
            if ($countgetmydevice > 0) {
                return response()->json(

                    $getmydevice,

                );
            }
        }
    }

    public function regstokun(Request $request)
    {
        $fotocheck = $request->fotocheck;
        $foto = $request->foto;
        $brand_id = $request->brand_id;
        $pajisja_id = $request->pajisja_id;
        $sasia = $request->sasia;
        $max = $request->max;
        $nrsasislimit = $request->nrsasislimit;
        $maxsasilimit = $request->maxsasilimit;
        $cmimi = $request->cmimi;
        $cmcheck = $request->cmcheck;
        $userid = $request->userid;
        $tvsh = $request->tvsh;
        $ekziston = DB::select("SELECT * FROM `stockupaisje` WHERE pasjisja_id='" . $pajisja_id . "' AND brend_id='" . $brand_id . "'");
        if ($ekziston != null) {
            $res['success'] = false;
            $res['message'] = "Paisja është në Stock!";
            return response($res, 400);
        }
        try {
            $_reg = DB::insert("INSERT INTO `stockupaisje`(`brend_id`, `pasjisja_id`, `sasia`, `maxporosi`, `sasialimituar`, `minporosi`, `cmimi`, `shfaqcmimin`,  `nga_perdoruesi`, `foto`,tvsh,fotocheck) 
            VALUES (?,?,?,?,?,?,?,?,?,?,?,?)", [$brand_id, $pajisja_id, $sasia, $max, $nrsasislimit, $maxsasilimit, $cmimi, $cmcheck, $userid, $foto, $tvsh, $fotocheck]);

            $res['success'] = true;
            $res['message'] = "Stoku u regjistrua me sukses! ";
            return response($res, 200);
        } catch (\Illuminate\Database\QueryException $ex) {
            $res['success'] = false;
            $res['message'] ='Error';
            return response($res, 500);
        }
    }
    public function edregstokun(Request $request)
    {
        $fotocheck = $request->fotocheck;
        $foto = $request->foto;
        $id = $request->id;

        $sasia = $request->sasia;
        $max = $request->max;
        $nrsasislimit = $request->nrsasislimit;
        $maxsasilimit = $request->maxsasilimit;
        $cmimi = $request->cmimi;
        $cmcheck = $request->cmcheck;
        $userid = $request->userid;
        $tvsh = $request->tvsh;

        try {
            $_reg = DB::table('stockupaisje')->where('Id', $id)->limit(1)->update([
                'sasia' => $sasia,
                'maxporosi' => $max,
                'sasialimituar' => $nrsasislimit,
                'minporosi' => $maxsasilimit,
                'cmimi' => $cmimi,
                'shfaqcmimin' => $cmcheck,
                'foto' => $foto,
                'tvsh' => $tvsh,
                'fotocheck' => $fotocheck,
                'nga_perdoruesi' => $userid,
            ]);
            $res['success'] = true;
            $res['message'] = "Stoku u regjistrua me sukses! ";
            return response($res, 200);
        } catch (\Illuminate\Database\QueryException $ex) {
            $res['success'] = false;
            $res['message'] ='Error';
            return response($res, 500);
        }
    }
    public function blerjatemp(Request $request)
    {
        $brand_id = $request->brand_id;
        $pajisja_id = $request->pajisja_id;
        $sasia = $request->sasia;
        $cmimi = $request->cmimi;
        $userid = $request->userid;
        $reagjent = $request->input('reagjent',null) ;
        if ($reagjent) {
            $ekziston = DB::select("SELECT * FROM `blerjapaisjev_temporary` WHERE Reagjent_id='" . $reagjent  . "' AND user='" . $userid . "'");
        } else {
            $ekziston = DB::select("SELECT * FROM `blerjapaisjev_temporary` WHERE (paisje_id='" . $pajisja_id . "' AND user='" . $userid . "')");
        }
    
        if ($ekziston != null) {
            $res['success'] = false;
            $res['message'] = "Paisja është në shportë!";
            return response($res, 401);
        }
        try {
            $_reg = DB::insert(
                "INSERT INTO `blerjapaisjev_temporary`( `brand_id`, `paisje_id`, `sasia`, `cmimi`, `user` ,Reagjent_id) 
            VALUES (?,?,?,?,?,?)",
                [$brand_id, $pajisja_id, $sasia, $cmimi, $userid,$reagjent]
            );

            $res['success'] = true;
            $res['message'] = " ";
            return response($res, 200);
        } catch (\Illuminate\Database\QueryException $ex) {
            $res['success'] = false;
            $res['message'] ='Error';
            return response($res, 500);
        }
    }
    public function porosit($id)
    {
        try {
            $_reg = DB::insert("CALL `porosit`(" . $id . ")");

            $res['success'] = true;
            $res['message'] = " ";
            return response($res, 200);
        } catch (\Illuminate\Database\QueryException $ex) {
            $res['success'] = false;
            $res['message'] = "Error";
            return response($res, 500);
        }
    }
    public function fshirjatemp($id)
    {
        try {
            $_reg = DB::delete("DELETE FROM `blerjapaisjev_temporary` WHERE user=" . $id);

            $res['success'] = true;
            $res['message'] = "sukses";
            return response($res, 200);
        } catch (\Illuminate\Database\QueryException $ex) {
            $res['success'] = false;
            $res['message'] = "Error";
            return response($res, 500);
        }
    }
    public function fshirjapaisjetemp( $id)
    {
        try {
            $_reg = DB::delete("DELETE FROM `blerjapaisjev_temporary` WHERE Id=" . $id);

            $res['success'] = true;
            $res['message'] = "sukses";
            return response($res, 200);
        } catch (\Illuminate\Database\QueryException $ex) {
            $res['success'] = false;
            $res['message'] = "Error";
            return response($res, 500);
        }
    }

    public function paisjetst($id)
    {

        $getmydevice = DB::select('SELECT 
        CASE
        WHEN fotocheck = 1  THEN s.foto
        ELSE  f.image  
        END
         as foto, s.cmimi,s.shfaqcmimin,s.maxporosi
        ,s.sasialimituar,s.minporosi,s.brend_id,
         s.sasia,s.pasjisja_id,f.emri_pajisjes ,fr.emri_prodhuesit FROM `stockupaisje` s 
         LEFT JOIN pajisja f ON s.pasjisja_id=f.id 
         LEFT JOIN firma_prodhuese_pajisjeve fr ON s.brend_id=fr.id 
         WHERE s.brend_id=' . $id);

        if (empty($getmydevice)) {
            $arr = array(300);
            echo json_encode($arr);
        } else {
            $countgetmydevice = count($getmydevice);
            if ($countgetmydevice > 0) {
                return response()->json(

                    $getmydevice,

                );
            }
        }
    }

    public function gettemp($id)
    {
        $getmydevice = DB::select('SELECT bt.*,br.emri_prodhuesit,
        CASE WHEN bt.Reagjent_id IS NULL THEN p.emri_pajisjes 
        ELSE  st.Emri 
        END as emri_pajisjes
          FROM blerjapaisjev_temporary bt 
        LEFT JOIN firma_prodhuese_pajisjeve br ON br.id=bt.brand_id 
        LEFT JOIN pajisja p ON p.id=bt.paisje_id
        LEFT JOIN stockureagjent st ON st.ID=bt.Reagjent_id
         WHERE user=' . $id);
        if (empty($getmydevice)) {
            $arr = array(300);
            echo json_encode($arr);
        } else {
            $countgetmydevice = count($getmydevice);
            if ($countgetmydevice > 0) {
                return response()->json(

                    $getmydevice,

                );
            }
        }
    }
    public function getporosite($sts)
    {
        if ($sts == 'all') {
            $getmydevice = DB::select('SELECT tb.id as instid, prd.emri as pranemri,prd.mbiemri as pranmbiemri, p.*,pr.emri,
        tb.emri_institutit, pr.mbiemri, qy.emri_qytetit, st.emertimi FROM porosihistori p LEFT JOIN perdoruesit pr ON pr.id=p.userid LEFT JOIN perdoruesit prd ON prd.id=p.pranuar_nga LEFT JOIN tbl_institucioni tb ON tb.id=pr.institucioni LEFT JOIN qyteti qy ON qy.id=pr.adresa LEFT JOIN statuset_kerkesave st ON p.statusi=st.statusi');
        } else {
            $getmydevice = DB::select('SELECT prd.emri as pranemri,prd.mbiemri as pranmbiemri, p.*,pr.emri,
            tb.emri_institutit, pr.mbiemri, qy.emri_qytetit, st.emertimi FROM porosihistori p LEFT JOIN perdoruesit pr ON pr.id=p.userid LEFT JOIN perdoruesit prd ON prd.id=p.pranuar_nga LEFT JOIN tbl_institucioni tb ON tb.id=pr.institucioni LEFT JOIN qyteti qy ON qy.id=pr.adresa LEFT JOIN statuset_kerkesave st ON p.statusi=st.statusi where  p.statusi=' . $sts);
        }
        if (empty($getmydevice)) {
            $arr = array(300);
            echo json_encode($arr);
        } else {
            $countgetmydevice = count($getmydevice);
            if ($countgetmydevice > 0) {
                return response()->json(

                    $getmydevice,

                );
            }
        }
    }
    public function getporositepopup($id)
    {
        $getmydevice = DB::select('SELECT pr.nr_kontaktues,prd.id, prd.emri as pranemri,prd.mbiemri as pranmbiemri, p.*,pr.emri,tb.adressa,tb.numri_biznesit,tb.nr_fiskal,pr.perdoruesi,
        CASE WHEN por.Reagjent_id IS NULL THEN pais.emri_pajisjes 
        ELSE  st.Emri 
        END as emri_pajisjes
       
        
        ,por.sasia,por.cmimi,stock.tvsh,
        tb.emri_institutit, pr.mbiemri, qy.emri_qytetit 
        FROM porosihistori p 
        LEFT JOIN porosit por ON por.historiid=p.Id
        LEFT JOIN perdoruesit pr ON pr.id=p.userid
        LEFT JOIN perdoruesit prd ON prd.id=p.pranuar_nga 
        LEFT JOIN tbl_institucioni tb ON tb.id=pr.institucioni 
        LEFT JOIN qyteti qy ON qy.id=pr.adresa
         LEFT JOIN stockupaisje stock ON stock.pasjisja_id=por.paisje_id
        LEFT JOIN pajisja pais ON pais.id=por.paisje_id
        LEFT JOIN stockureagjent st ON st.ID=por.Reagjent_id
         WHERE p.Id=
' . $id);
        if (empty($getmydevice)) {
            $arr = array(300);
            echo json_encode($arr);
        } else {
            $countgetmydevice = count($getmydevice);
            if ($countgetmydevice > 0) {
                return response()->json(

                    $getmydevice,

                );
            }
        }
    }
    public function getdetajeporosi($id)
    {
        $getmydevice = DB::select('SELECT o.* ,pr.emri,pr.mbiemri,st.emertimi FROM order_history o
        LEFT JOIN perdoruesit pr ON pr.id=o.user_id
       LEFT JOIN statuset_kerkesave st ON o.statusi=st.statusi WHERE o.VisitID
        =
' . $id);
        if (empty($getmydevice)) {
            $arr = array(300);
            echo json_encode($arr);
        } else {
            $countgetmydevice = count($getmydevice);
            if ($countgetmydevice > 0) {
                return response()->json(

                    $getmydevice,

                );
            }
        }
    }
    public function porosiasts(Request $request)
    {
        $histid = $request->histid;
        $sts = $request->sts;
        $userid = $request->userid;
        $Komenti = $request->Komenti;
        $data = Carbon::now();
        $kmnt = $request->kmnt;
        try {
            if ($kmnt == 1) {
                $_reg = DB::update("UPDATE `porosihistori` SET `statusi`='" . $sts . "',`komenti`='" . $Komenti . "' WHERE Id=" . $histid);
            } else {
                $_reg = DB::update("UPDATE `porosihistori` SET `statusi`='" . $sts . "' WHERE Id=" . $histid);
            }
            $_reg = DB::insert("INSERT INTO `order_history`( `user_id`, `VisitID`, `Komenti`, `data`, `statusi`) VALUES ('$userid','$histid','$Komenti','$data','$sts')");

            $res['success'] = true;
            $res['message'] = "Porosia statusi iu ndryshua me sukses! ";
            return response($res, 200);
        } catch (\Illuminate\Database\QueryException $ex) {
            $res['success'] = false;
            $res['message'] = "Error";
            return response($res, 500);
        }
    }
    public function pranoporosi(Request $request)
    {
        $histid = $request->histid;
        $lirimi = $request->lirimi;


        $Komenti = $request->Komenti;
        $pranuar_nga = $request->pranuar_nga;
        $data = Carbon::now();
        $kohaliferimit = $request->kohaliferimit;
        $afatipages = $request->afatipages;

        try {
            if ($request->kohaliferimit === '' && $request->afatipages === '') {
                $_reg = DB::update("UPDATE `porosihistori` SET koha_liferimit=NULL, lirimi='" . $lirimi . "', `komenti`='" . $Komenti . "', `pranuar_nga`='" . $pranuar_nga . "' , `data_pranimit`='" . $data . "'  WHERE Id=" . $histid);
            } else   if ($request->afatipages === '') {
                $_reg = DB::update("UPDATE `porosihistori` SET koha_liferimit='" . $kohaliferimit . "',lirimi='" . $lirimi . "',  `komenti`='" . $Komenti . "', `pranuar_nga`='" . $pranuar_nga . "' , `data_pranimit`='" . $data . "'  WHERE Id=" . $histid);
            } else   if ($request->kohaliferimit === '') {
                $_reg = DB::update("UPDATE `porosihistori`  SET afatipageses='" . $afatipages . "', lirimi='" . $lirimi . "', koha_liferimit=NULL,  `komenti`='" . $Komenti . "', `pranuar_nga`='" . $pranuar_nga . "' , `data_pranimit`='" . $data . "'  WHERE Id=" . $histid);
            } else {

                $_reg = DB::update("UPDATE `porosihistori` SET  afatipageses='" . $afatipages . "',lirimi='" . $lirimi . "', `koha_liferimit`='" . $kohaliferimit . "', `komenti`='" . $Komenti . "', `pranuar_nga`='" . $pranuar_nga . "' , `data_pranimit`='" . $data . "'  WHERE Id=" . $histid);
            }

            $res['success'] = true;
            $res['message'] = "Porosia statusi iu ndryshua me sukses! ";
            return response($res, 200);
        } catch (\Illuminate\Database\QueryException $ex) {
            $res['success'] = false;
            $res['message'] = "Error";
            return response($res, 500);
        }
    }
    public function regreagjent(Request $request)
    {

        $brand_id = $request->brand_id;
        $pajisja_id = $request->pajisja_id;

        $sasia = $request->sasia;
        $emri = $request->emri;
        $cmimi = $request->cmimi;



        try {
            for ($i = 0; $i < count($emri); $i++) {

                $_reg = DB::table('stockureagjent')->insert([
                    'brand_id' => $brand_id,
                    'paisje_id' => $pajisja_id,
                    'Emri' => $emri[$i],
                    'Sasia' => $sasia[$i] ?? null,
                    'cmimi' => $cmimi[$i] ?? null,
                ]);
            }
            $res['success'] = true;
            $res['message'] = "Stoku u regjistrua me sukses! ";
            return response($res, 200);
        } catch (\Illuminate\Database\QueryException $ex) {
            $res['success'] = false;
            $res['message'] ='Error';
            return response($res, 500);
        }
    }
    public function getreagjent(Request $request)
    {
        $brend = $request->input('brend', null);
        $paisje = $request->input('paisje', null);
        $emri = $request->input('emri', null);
        $products = DB::table('stockureagjent')->select(['stockureagjent.*','pajisja.emri_pajisjes','firma_prodhuese_pajisjeve.emri_prodhuesit'])
        ->leftJoin('pajisja', 'stockureagjent.paisje_id', '=', 'pajisja.id')
        ->leftJoin('firma_prodhuese_pajisjeve', 'stockureagjent.brand_id', '=', 'firma_prodhuese_pajisjeve.id')
        ->where(function ($q) use ($brend) {
            if ($brend) {
                $q->where('brand_id', $brend);
            }
        })->where(function ($q) use ($paisje) {
            if ($paisje) {
                $q->where('paisje_id', $paisje);
            }
        })->where(function ($q) use ($emri) {
            if ($emri) {
                $q->where('Emri', 'like', '%' . $emri . '%');
            }
        })->get(['*']);

        return response()->json(array(
            'code' => 200,
            'data' => $products
        ), 200);
    }
}
