<?php

/** @var \Laravel\Lumen\Routing\Router $router */

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It is a breeze. Simply tell Lumen the URIs it should respond to
| and give it the Closure to call when that URI is requested.
|
*/
$router->get('/', function () use ($router) {
    return $router->app->version();
});

// Users Api
$router->get('/countus', 'LoginController@patients');
$router->get('/getbyid/{id}', 'UserController@show');
$router->get('/getallusers', 'UserController@getallusers');
$router->get('/getmyusers/{institut}', 'UserController@getmyusers');


// CRUD of requsts 
$router->get('/showrequests', 'RequestsController@showrequests');
$router->get('/crudrequests', 'RequestsController@kerkesa');
$router->get('/getbyvisit/{id}', 'RequestsController@getbyvisit');
$router->get('/getpaisjevisit/{id}', 'RequestsController@getpaisjevisit');
$router->get('/getservisit/{id}/{pid}', 'RequestsController@getservisit');
$router->get('/showkomentimin/{vid}', 'RequestsController@showkomentimin');
$router->post('/shtokomentimin', 'RequestsController@shtokomentimin');
$router->put('/updprocesuar/{vid}/{pid}', 'RequestsController@updprocesuar');
$router->put('/refuzokerkesen/{vid}/{uid}', 'RequestsController@refuzokerkesen');
$router->put('/aprovokerkesen/{vid}/{uid}', 'RequestsController@aprovokerkesen');
$router->put('/kthejepritje/{vid}/{uid}', 'RequestsController@kthejepritje');
$router->put('/mbyllkerkesen/{vid}/{uid}', 'RequestsController@mbyllkerkesen');
$router->get('/getkerkesapritje/{instituti}', 'RequestsController@getkerkesapritje');
$router->get('/getkerkesaproces/{instituti}', 'RequestsController@getkerkesaproces');
$router->put('/delegouser', 'RequestsController@delegouser');

// Crud of POZITAT / ROLES 
$router->get('/pozitat', 'UserController@pozitat');
// Crud of Porosi / ROLES 
$router->get('/getvisit', 'PorosiController@getvisit');
$router->get('/getreagjent', 'PorosiController@getreagjent');
$router->get('/brendet', 'PorosiController@brendet');
$router->get('/paisjetst/{id}', 'PorosiController@paisjetst');
$router->get('/gettemp/{id}', 'PorosiController@gettemp');
$router->post('/regstokun', 'PorosiController@regstokun');
$router->post('/regreagjent', 'PorosiController@regreagjent');
$router->put('/edregstokun', 'PorosiController@edregstokun');
$router->post('/blerjatemp', 'PorosiController@blerjatemp');
$router->post('/porosit/{id}', 'PorosiController@porosit');
$router->delete('/fshirjapaisjetemp/{id}', 'PorosiController@fshirjapaisjetemp');
$router->delete('/fshirjatemp/{id}', 'PorosiController@fshirjatemp');
$router->get('/getdetajeporosi/{id}', 'PorosiController@getdetajeporosi');
$router->put('/porosiasts', 'PorosiController@porosiasts');
$router->put('/pranoporosi', 'PorosiController@pranoporosi');
$router->get('/getporosite/{sts}', 'PorosiController@getporosite');
$router->get('/getporositepopup/{id}', 'PorosiController@getporositepopup');
// Crud of City
$router->post('/qyteti', 'CityController@qyteti');
$router->get('/getqytet', 'CityController@getqytet');
$router->get('/qytetibyid', 'CityController@qytetibyid');
$router->put('/updqytet', 'CityController@updqytet');

// CRUD of Furnitor
$router->get('/klienti', 'ClientController@klienti');
$router->put('/updklienti', 'ClientController@updklienti');
$router->post('/servicepdf', 'ClientController@servicepdf');
$router->post('/porosipdf', 'ClientController@porosipdf');
$router->get('/getservicepdf', 'ClientController@getservicepdf');
$router->get('/getporosipdf', 'ClientController@getporosipdf');
$router->get('/checksession', 'ClientController@checksession');
// Crud of User
$router->post('/perdoruesi', 'UserController@perdoruesi');
$router->post('/register', 'UserController@register');
$router->get('/getlejet/{id}', 'UserController@getlejet');
$router->post('/insertnewroli', 'UserController@insertnewroli');
$router->put('/updlejet/{id}', 'UserController@updlejet');
$router->get('/getpozitaid', 'UserController@getpozitaid');
$router->put('/updatepozita', 'UserController@updatepozita');
$router->get('/getallinstitut', 'UserController@getallinstitut');
$router->put('/updperdoruesi', 'UserController@updperdoruesi');
$router->post('/shtoperdoruesi', 'UserController@shtoperdoruesi');

// Crud of SERVICES AND PAJISJET AND BRANDS
$router->post('/pajisja', 'ServicesnbrandsController@pajisja');
$router->get('/shfaqpajsije/{id}', 'ServicesnbrandsController@shfaqpajsije');
$router->get('/get_pp/{id}', 'ServicesnbrandsController@get_pp');
$router->put('/update_pp/{id}', 'ServicesnbrandsController@update_pp');
$router->get('/tbl_stock', 'ServicesnbrandsController@tbl_stock');

// Crud of BRAND, FIRMA, FIRMA PRODHUESE, FURNITORET
$router->post('/serviceins', 'ServicesnbrandsController@serviceins');
$router->post('/paisjains', 'ServicesnbrandsController@paisjains');
$router->post('/firmains', 'ServicesnbrandsController@firmains');
$router->post('/shtokerkes', 'ServicesnbrandsController@shtokerkes');
$router->post('/servisfirma', 'ServicesnbrandsController@shtoservisefirma');
$router->post('/caktopaisjes', 'ServicesnbrandsController@caktopaisjes');
$router->post('/firma', 'ServicesnbrandsController@firma');
$router->get('/service', 'ServicesnbrandsController@service');
$router->get('/paisjeforfirma/{id}', 'ServicesnbrandsController@paisjeforfirma');
$router->get('/servpaisje/{id}', 'ServicesnbrandsController@servpaisje');
$router->get('/perkatsipaisja/{id}', 'ServicesnbrandsController@perkatsipaisja');
$router->get('/prioritete', 'ServicesnbrandsController@prioritete');
$router->get('/showtable', 'ServicesnbrandsController@tbl_serv_brand_institution');
$router->get('/getkerkesaid', 'ServicesnbrandsController@getkerkesaid');
$router->put('/updatebrend', 'ServicesnbrandsController@updatebrend');
$router->put('/updateservice', 'ServicesnbrandsController@updateservice');
$router->put('/updateprioriteti', 'ServicesnbrandsController@updateprioriteti');
$router->put('/updatepajisja', 'ServicesnbrandsController@updatepajisja');

/////////////////////////////////////////////////////////////////////////
// ///////////////////////////////////////////////////////////////////////



//Register
$router->put('/ndryshopsw', 'RegisterController@ndryshopsw');
//Logins
$router->post('/login', 'LoginController@loginApp');
$router->post('/login_logs', 'LoginController@login_logs');
$router->get('/countusers', 'LoginController@users');
//city
$router->post('/city', 'CityController@city');
$router->get('/getcity', 'CityController@index');
